/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class HeaderlessBamOutputFormat
extends FileOutputFormat<Void, SAMRecord> {
    private static SAMFileHeader header;

    public static void setHeader(SAMFileHeader samFileHeader) {
        header = samFileHeader;
    }

    public RecordWriter<Void, SAMRecord> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Path file = this.getDefaultWorkFile(taskAttemptContext, "");
        return new BamRecordWriter(taskAttemptContext.getConfiguration(), file, header);
    }

    static class BamRecordWriter
    extends RecordWriter<Void, SAMRecord> {
        private final OutputStream out;
        private final BinaryCodec binaryCodec;
        private final BAMRecordCodec bamRecordCodec;

        public BamRecordWriter(Configuration conf, Path file, SAMFileHeader header) throws IOException {
            this.out = file.getFileSystem(conf).create(file);
            BlockCompressedOutputStream compressedOut = new BlockCompressedOutputStream(this.out, (File)null);
            this.binaryCodec = new BinaryCodec((OutputStream)compressedOut);
            this.bamRecordCodec = new BAMRecordCodec(header);
            this.bamRecordCodec.setOutputStream((OutputStream)compressedOut);
        }

        public void write(Void ignore, SAMRecord samRecord) {
            this.bamRecordCodec.encode(samRecord);
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException {
            this.binaryCodec.getOutputStream().flush();
            this.out.close();
        }
    }
}

