/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.cram;

import htsjdk.samtools.CRAMContainerStreamWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class CramOutputFormat
extends FileOutputFormat<Void, SAMRecord> {
    private static SAMFileHeader header;
    private static CRAMReferenceSource refSource;

    public static void setHeader(SAMFileHeader samFileHeader) {
        header = samFileHeader;
    }

    public static void setReferenceSource(CRAMReferenceSource referenceSource) {
        refSource = referenceSource;
    }

    public RecordWriter<Void, SAMRecord> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Path file = this.getDefaultWorkFile(taskAttemptContext, "");
        return new CramRecordWriter(taskAttemptContext.getConfiguration(), file, header, refSource);
    }

    static class CramRecordWriter
    extends RecordWriter<Void, SAMRecord> {
        private final OutputStream out;
        private final CRAMContainerStreamWriter cramWriter;

        public CramRecordWriter(Configuration conf, Path file, SAMFileHeader header, CRAMReferenceSource refSource) throws IOException {
            this.out = file.getFileSystem(conf).create(file);
            this.cramWriter = new CRAMContainerStreamWriter(this.out, null, refSource, header, file.toString());
        }

        public void write(Void ignore, SAMRecord samRecord) {
            this.cramWriter.writeAlignment(samRecord);
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException {
            this.cramWriter.finish(false);
            this.out.close();
        }
    }
}

