/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.cram;

import htsjdk.samtools.CRAMContainerStreamWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.Merger;
import org.disq_bio.disq.impl.file.NioFileSystemWrapper;
import org.disq_bio.disq.impl.formats.cram.CramOutputFormat;
import org.disq_bio.disq.impl.formats.sam.AbstractSamSink;
import scala.Tuple2;

public class CramSink
extends AbstractSamSink {
    private FileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();

    @Override
    public void save(JavaSparkContext jsc, SAMFileHeader header, JavaRDD<SAMRecord> reads, String path, String referenceSourcePath, String tempPartsDirectory) throws IOException {
        ReferenceSource referenceSource = new ReferenceSource(NioFileSystemWrapper.asPath(referenceSourcePath));
        Broadcast headerBroadcast = jsc.broadcast((Object)header);
        Broadcast referenceSourceBroadCast = jsc.broadcast((Object)referenceSource);
        reads.mapPartitions((FlatMapFunction & Serializable)readIterator -> {
            CramOutputFormat.setHeader((SAMFileHeader)headerBroadcast.getValue());
            CramOutputFormat.setReferenceSource((CRAMReferenceSource)referenceSourceBroadCast.getValue());
            return readIterator;
        }).mapToPair((PairFunction & Serializable)samRecord -> new Tuple2(null, samRecord)).saveAsNewAPIHadoopFile(tempPartsDirectory, Void.class, SAMRecord.class, CramOutputFormat.class, jsc.hadoopConfiguration());
        String headerFile = tempPartsDirectory + "/header";
        try (OutputStream out = this.fileSystemWrapper.create(jsc.hadoopConfiguration(), headerFile);){
            this.writeHeader(header, out, headerFile, referenceSource);
        }
        String terminatorFile = tempPartsDirectory + "/terminator";
        try (OutputStream out = this.fileSystemWrapper.create(jsc.hadoopConfiguration(), terminatorFile);){
            CramIO.issueEOF((Version)CramVersions.DEFAULT_CRAM_VERSION, (OutputStream)out);
        }
        new Merger().mergeParts(jsc.hadoopConfiguration(), tempPartsDirectory, path);
        this.fileSystemWrapper.delete(jsc.hadoopConfiguration(), tempPartsDirectory);
    }

    private void writeHeader(SAMFileHeader header, OutputStream out, String headerFile, ReferenceSource referenceSource) {
        CRAMContainerStreamWriter cramWriter = new CRAMContainerStreamWriter(out, null, (CRAMReferenceSource)referenceSource, header, headerFile);
        cramWriter.writeHeader(header);
        cramWriter.finish(false);
    }
}

