/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.Locatable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.disq_bio.disq.HtsjdkReadsTraversalParameters;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.formats.sam.SamFormat;

public abstract class AbstractSamSource
implements Serializable {
    protected final FileSystemWrapper fileSystemWrapper;

    protected AbstractSamSource(FileSystemWrapper fileSystemWrapper) {
        this.fileSystemWrapper = fileSystemWrapper;
    }

    public abstract SamFormat getSamFormat();

    public SAMFileHeader getFileHeader(JavaSparkContext jsc, String path, ValidationStringency stringency, String referenceSourcePath) throws IOException {
        Configuration conf = jsc.hadoopConfiguration();
        String firstSamPath = this.fileSystemWrapper.isDirectory(conf, path) ? this.fileSystemWrapper.firstFileInDirectory(conf, path) : path;
        try (SamReader samReader = this.createSamReader(conf, firstSamPath, stringency, referenceSourcePath);){
            SAMFileHeader sAMFileHeader = samReader.getFileHeader();
            return sAMFileHeader;
        }
    }

    public abstract <T extends Locatable> JavaRDD<SAMRecord> getReads(JavaSparkContext var1, String var2, int var3, HtsjdkReadsTraversalParameters<T> var4, ValidationStringency var5, String var6) throws IOException;

    protected SamReader createSamReader(Configuration conf, String path, ValidationStringency stringency, String referenceSourcePath) throws IOException {
        SeekableStream in = this.fileSystemWrapper.open(conf, path);
        SeekableStream indexStream = this.findIndex(conf, path);
        SamReaderFactory readerFactory = SamReaderFactory.makeDefault().setOption(SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES, true).setOption(SamReaderFactory.Option.EAGERLY_DECODE, false).setUseAsyncIo(false);
        if (stringency != null) {
            readerFactory.validationStringency(stringency);
        }
        if (referenceSourcePath != null) {
            SeekableStream refIn = this.fileSystemWrapper.open(conf, referenceSourcePath);
            try (SeekableStream indexIn = this.fileSystemWrapper.open(conf, referenceSourcePath + ".fai");){
                FastaSequenceIndex index = new FastaSequenceIndex((InputStream)indexIn);
                ReferenceSequenceFile refSeqFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((String)referenceSourcePath, (SeekableStream)refIn, (FastaSequenceIndex)index);
                readerFactory.referenceSource((CRAMReferenceSource)new ReferenceSource(refSeqFile));
            }
        }
        SamInputResource resource = SamInputResource.of((SeekableStream)in);
        if (indexStream != null) {
            resource.index(indexStream);
        }
        SamReader samReader = readerFactory.open(resource);
        this.ensureIndexWillBeClosed(samReader);
        return samReader;
    }

    protected SeekableStream findIndex(Configuration conf, String path) throws IOException {
        SamFormat samFormat = this.getSamFormat();
        if (samFormat.getIndexExtension() == null) {
            return null;
        }
        String index = path + samFormat.getIndexExtension();
        if (this.fileSystemWrapper.exists(conf, index)) {
            return this.fileSystemWrapper.open(conf, index);
        }
        index = path.replaceFirst(Pattern.quote(samFormat.getExtension()) + "$", samFormat.getIndexExtension());
        if (this.fileSystemWrapper.exists(conf, index)) {
            return this.fileSystemWrapper.open(conf, index);
        }
        return null;
    }

    private SamReader ensureIndexWillBeClosed(SamReader samReader) {
        SamReader.PrimitiveSamReader underlyingReader = ((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader).underlyingReader();
        if (underlyingReader.hasIndex()) {
            underlyingReader.getIndex();
        }
        return samReader;
    }

    protected static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(((Iterable)() -> iterator).spliterator(), false);
    }
}

