/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.NioFileSystemWrapper;
import org.disq_bio.disq.impl.formats.sam.AbstractSamSink;
import org.disq_bio.disq.impl.formats.sam.AnySamOutputFormat;
import org.disq_bio.disq.impl.formats.sam.SamFormat;
import scala.Tuple2;

public class AnySamSinkMultiple
extends AbstractSamSink
implements Serializable {
    private SamFormat samFormat;

    public AnySamSinkMultiple(SamFormat samFormat) {
        this.samFormat = samFormat;
    }

    @Override
    public void save(JavaSparkContext jsc, SAMFileHeader header, JavaRDD<SAMRecord> reads, String path, String referenceSourcePath, String tempPartsDirectory) throws IOException {
        HadoopFileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();
        if (fileSystemWrapper.exists(jsc.hadoopConfiguration(), path)) {
            fileSystemWrapper.delete(jsc.hadoopConfiguration(), path);
        }
        ReferenceSource referenceSource = referenceSourcePath == null ? null : new ReferenceSource(NioFileSystemWrapper.asPath(referenceSourcePath));
        Broadcast headerBroadcast = jsc.broadcast((Object)header);
        Broadcast referenceSourceBroadCast = jsc.broadcast((Object)referenceSource);
        reads.mapPartitions((FlatMapFunction & Serializable)readIterator -> {
            AnySamOutputFormat.setHeader((SAMFileHeader)headerBroadcast.getValue());
            AnySamOutputFormat.setSamFormat(this.samFormat);
            AnySamOutputFormat.setReferenceSource((CRAMReferenceSource)referenceSourceBroadCast.getValue());
            return readIterator;
        }).mapToPair((PairFunction & Serializable)samRecord -> new Tuple2(null, samRecord)).saveAsNewAPIHadoopFile(path, Void.class, SAMRecord.class, AnySamOutputFormat.class, jsc.hadoopConfiguration());
    }
}

