/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.vcf;

import com.google.common.collect.Iterators;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFEncoder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.Merger;
import org.disq_bio.disq.impl.formats.bgzf.BGZFCodec;
import org.disq_bio.disq.impl.formats.vcf.AbstractVcfSink;

public class VcfSink
extends AbstractVcfSink {
    private FileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();

    @Override
    public void save(JavaSparkContext jsc, VCFHeader vcfHeader, JavaRDD<VariantContext> variants, String path, String tempPartsDirectory) throws IOException {
        boolean compressed;
        Broadcast vcfHeaderBroadcast = jsc.broadcast((Object)vcfHeader);
        JavaRDD variantStrings = variants.mapPartitions((FlatMapFunction & Serializable)variantContexts -> {
            VCFEncoder vcfEncoder = new VCFEncoder((VCFHeader)vcfHeaderBroadcast.getValue(), false, false);
            return Iterators.transform((Iterator)variantContexts, arg_0 -> ((VCFEncoder)vcfEncoder).encode(arg_0));
        });
        boolean bl = compressed = path.endsWith(".bgz") || path.endsWith(".gz");
        if (compressed) {
            variantStrings.saveAsTextFile(tempPartsDirectory, BGZFCodec.class);
        } else {
            variantStrings.saveAsTextFile(tempPartsDirectory);
        }
        String headerFile = tempPartsDirectory + "/header" + (compressed ? ".bgz" : "");
        try (OutputStream headerOut = this.fileSystemWrapper.create(jsc.hadoopConfiguration(), headerFile);){
            OutputStream out = compressed ? new BlockCompressedOutputStream(headerOut, (File)null) : headerOut;
            VariantContextWriter writer = new VariantContextWriterBuilder().clearOptions().setOutputVCFStream(out).build();
            writer.writeHeader(vcfHeader);
            out.flush();
        }
        if (compressed) {
            String terminatorFile = tempPartsDirectory + "/terminator";
            try (OutputStream out = this.fileSystemWrapper.create(jsc.hadoopConfiguration(), terminatorFile);){
                out.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
            }
        }
        new Merger().mergeParts(jsc.hadoopConfiguration(), tempPartsDirectory, path);
        this.fileSystemWrapper.delete(jsc.hadoopConfiguration(), tempPartsDirectory);
    }
}

