/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.vcf;

import htsjdk.samtools.SamStreams;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderVersion;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.formats.bgzf.BGZFCodec;
import org.disq_bio.disq.impl.formats.bgzf.BGZFEnhancedGzipCodec;
import org.disq_bio.disq.impl.formats.tribble.TribbleIndexIntervalFilteringTextInputFormat;
import org.disq_bio.disq.impl.formats.vcf.VcfFormat;

public class VcfSource
implements Serializable {
    private FileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();

    public VCFHeader getFileHeader(JavaSparkContext jsc, String path) throws IOException {
        try (SeekableStream headerIn = this.fileSystemWrapper.open(jsc.hadoopConfiguration(), this.getFirstPath(jsc, path));){
            InputStream is = VcfSource.bufferAndDecompressIfNecessary((InputStream)headerIn);
            FeatureCodecHeader featureCodecHeader = new VCFCodec().readHeader((LineIterator)new AsciiLineReaderIterator(AsciiLineReader.from((InputStream)is)));
            VCFHeader vCFHeader = (VCFHeader)featureCodecHeader.getHeaderValue();
            return vCFHeader;
        }
    }

    private VCFCodec getVCFCodec(JavaSparkContext jsc, String path) throws IOException {
        try (SeekableStream headerIn = this.fileSystemWrapper.open(jsc.hadoopConfiguration(), this.getFirstPath(jsc, path));){
            InputStream is = VcfSource.bufferAndDecompressIfNecessary((InputStream)headerIn);
            VCFCodec vcfCodec = new VCFCodec();
            vcfCodec.readHeader((LineIterator)new AsciiLineReaderIterator(AsciiLineReader.from((InputStream)is)));
            VCFCodec vCFCodec = vcfCodec;
            return vCFCodec;
        }
    }

    private String getFirstPath(JavaSparkContext jsc, String path) throws IOException {
        Configuration conf = jsc.hadoopConfiguration();
        String firstPath = this.fileSystemWrapper.isDirectory(conf, path) ? this.fileSystemWrapper.firstFileInDirectory(conf, path) : path;
        return firstPath;
    }

    private static InputStream bufferAndDecompressIfNecessary(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        return SamStreams.isGzippedSAMFile((InputStream)bis) ? new GZIPInputStream(bis) : bis;
    }

    public <T extends Locatable> JavaRDD<VariantContext> getVariants(JavaSparkContext jsc, String path, int splitSize, List<T> intervals) throws IOException {
        Configuration conf = jsc.hadoopConfiguration();
        if (splitSize > 0) {
            conf.setInt("mapreduce.input.fileinputformat.split.maxsize", splitSize);
        }
        this.enableBGZFCodecs(conf);
        VCFCodec vcfCodec = this.getVCFCodec(jsc, path);
        VCFHeader header = vcfCodec.getHeader();
        VCFHeaderVersion version = vcfCodec.getVersion();
        Broadcast headerBroadcast = jsc.broadcast((Object)header);
        Broadcast intervalsBroadcast = intervals == null ? null : jsc.broadcast(intervals);
        return this.textFile(jsc, conf, path, intervals).mapPartitions((FlatMapFunction & Serializable)lines -> {
            VCFCodec codec = new VCFCodec();
            codec.setVCFHeader((VCFHeader)headerBroadcast.getValue(), version);
            OverlapDetector overlapDetector = intervalsBroadcast == null ? null : OverlapDetector.create((List)((List)intervalsBroadcast.getValue()));
            return VcfSource.stream(lines).filter(line -> !line.startsWith("#")).map(arg_0 -> ((VCFCodec)codec).decode(arg_0)).filter(vc -> overlapDetector == null || overlapDetector.overlapsAny((Locatable)vc)).iterator();
        });
    }

    private void enableBGZFCodecs(Configuration conf) {
        List codecs = CompressionCodecFactory.getCodecClasses((Configuration)conf);
        if (!codecs.contains(BGZFEnhancedGzipCodec.class)) {
            codecs.remove(GzipCodec.class);
            codecs.add(BGZFEnhancedGzipCodec.class);
        }
        if (!codecs.contains(BGZFCodec.class)) {
            codecs.add(BGZFCodec.class);
        }
        CompressionCodecFactory.setCodecClasses((Configuration)conf, new ArrayList(codecs));
    }

    private <T extends Locatable> JavaRDD<String> textFile(JavaSparkContext jsc, Configuration conf, String path, List<T> intervals) throws IOException {
        if (intervals == null) {
            return jsc.newAPIHadoopFile(path, TextInputFormat.class, LongWritable.class, Text.class, jsc.hadoopConfiguration()).map((Function & Serializable)pair -> ((Text)pair._2).toString()).setName(path);
        }
        VcfFormat vcfFormat = VcfFormat.fromPath(path);
        String indexPath = vcfFormat == null ? path + ".tbi" : path + vcfFormat.getIndexExtension();
        if (!this.fileSystemWrapper.exists(conf, indexPath)) {
            throw new IllegalArgumentException("Intervals set but no index file found for " + path + " at " + indexPath);
        }
        try (InputStream indexIn = VcfSource.indexFileInputStream(indexPath, (InputStream)this.fileSystemWrapper.open(conf, indexPath));){
            Index index = IndexFactory.loadIndex((String)indexPath, (InputStream)indexIn);
            TribbleIndexIntervalFilteringTextInputFormat.setIndex(index);
            TribbleIndexIntervalFilteringTextInputFormat.setIntervals(intervals);
            JavaRDD javaRDD = jsc.newAPIHadoopFile(path, TribbleIndexIntervalFilteringTextInputFormat.class, LongWritable.class, Text.class, jsc.hadoopConfiguration()).map((Function & Serializable)pair -> ((Text)pair._2).toString()).setName(path);
            return javaRDD;
        }
    }

    private static InputStream indexFileInputStream(String indexPath, InputStream inputStreamInitial) throws IOException {
        if (indexPath.endsWith(".gz")) {
            return new GZIPInputStream(inputStreamInitial);
        }
        if (indexPath.endsWith(".tbi")) {
            return new BlockCompressedInputStream(inputStreamInitial);
        }
        return inputStreamInitial;
    }

    private static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(((Iterable)() -> iterator).spliterator(), false);
    }
}

