/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinaryBAMIndexWriter;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.VirtualShiftUtil;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BAMIndexMerger {
    private static final int UNINITIALIZED_WINDOW = -1;

    public static void merge(SAMFileHeader header, List<Long> partLengths, List<SeekableStream> baiStreams, OutputStream baiOut) {
        if (baiStreams.isEmpty()) {
            throw new IllegalArgumentException("Cannot merge zero BAI files");
        }
        SAMSequenceDictionary dict = header.getSequenceDictionary();
        ArrayList<CachingBAMFileIndex> bais = new ArrayList<CachingBAMFileIndex>();
        for (SeekableStream seekableStream : baiStreams) {
            bais.add(new CachingBAMFileIndex(seekableStream, dict));
        }
        int numReferences = ((AbstractBAMFileIndex)bais.get(0)).getNumberOfReferences();
        for (AbstractBAMFileIndex abstractBAMFileIndex : bais) {
            if (abstractBAMFileIndex.getNumberOfReferences() == numReferences) continue;
            throw new IllegalArgumentException(String.format("Cannot merge BAI files with different number of references, %s and %s.", numReferences, abstractBAMFileIndex.getNumberOfReferences()));
        }
        long[] lArray = partLengths.stream().mapToLong(i -> i).toArray();
        Arrays.parallelPrefix(lArray, (a, b) -> a + b);
        try (BinaryBAMIndexWriter binaryBAMIndexWriter = new BinaryBAMIndexWriter(numReferences, baiOut);){
            for (int ref = 0; ref < numReferences; ++ref) {
                ArrayList<BAMIndexContent> bamIndexContentList = new ArrayList<BAMIndexContent>();
                for (AbstractBAMFileIndex abstractBAMFileIndex : bais) {
                    bamIndexContentList.add(abstractBAMFileIndex.getQueryResults(ref));
                }
                BAMIndexContent bamIndexContent = BAMIndexMerger.mergeBAMIndexContent(ref, bamIndexContentList, lArray);
                binaryBAMIndexWriter.writeReference(bamIndexContent);
            }
            long noCoordinateCount = 0L;
            for (AbstractBAMFileIndex abstractBAMFileIndex : bais) {
                noCoordinateCount += abstractBAMFileIndex.getNoCoordinateCount().longValue();
            }
            binaryBAMIndexWriter.writeNoCoordinateRecordCount(Long.valueOf(noCoordinateCount));
        }
    }

    private static BAMIndexContent mergeBAMIndexContent(int referenceSequence, List<BAMIndexContent> bamIndexContentList, long[] offsets) {
        ArrayList<BinningIndexContent.BinList> binLists = new ArrayList<BinningIndexContent.BinList>();
        ArrayList<BAMIndexMetaData> metaDataList = new ArrayList<BAMIndexMetaData>();
        ArrayList<LinearIndex> linearIndexes = new ArrayList<LinearIndex>();
        for (BAMIndexContent bamIndexContent : bamIndexContentList) {
            binLists.add(bamIndexContent.getBins());
            metaDataList.add(bamIndexContent.getMetaData());
            linearIndexes.add(bamIndexContent.getLinearIndex());
        }
        return new BAMIndexContent(referenceSequence, BAMIndexMerger.mergeBins(binLists, offsets), BAMIndexMerger.mergeMetaData(metaDataList, offsets), BAMIndexMerger.mergeLinearIndexes(referenceSequence, linearIndexes, offsets));
    }

    public static BinningIndexContent.BinList mergeBins(List<BinningIndexContent.BinList> binLists, long[] offsets) {
        ArrayList<Bin> mergedBins = new ArrayList<Bin>();
        int maxBinNumber = binLists.stream().mapToInt(bl -> bl.maxBinNumber).max().orElse(0);
        int commonNonNullBins = 0;
        for (int i = 0; i <= maxBinNumber; ++i) {
            ArrayList<Bin> nonNullBins = new ArrayList<Bin>();
            for (int j = 0; j < binLists.size(); ++j) {
                BinningIndexContent.BinList binList = binLists.get(j);
                Bin bin = VirtualShiftUtil.shift(binList.getBin(i), offsets[j]);
                if (bin == null) continue;
                nonNullBins.add(bin);
            }
            if (nonNullBins.isEmpty()) continue;
            mergedBins.add(BAMIndexMerger.mergeBins(nonNullBins));
            commonNonNullBins += nonNullBins.size() - 1;
        }
        int numberOfNonNullBins = binLists.stream().mapToInt(BinningIndexContent.BinList::getNumberOfNonNullBins).sum() - commonNonNullBins;
        return new BinningIndexContent.BinList(mergedBins.toArray(new Bin[0]), numberOfNonNullBins);
    }

    private static Bin mergeBins(List<Bin> bins) {
        if (bins.isEmpty()) {
            throw new IllegalArgumentException("Cannot merge empty bins");
        }
        if (bins.size() == 1) {
            return bins.get(0);
        }
        int referenceSequence = bins.get(0).getReferenceSequence();
        int binNumber = bins.get(0).getBinNumber();
        ArrayList allChunks = new ArrayList();
        for (Bin b : bins) {
            if (b.getReferenceSequence() != referenceSequence) {
                throw new IllegalArgumentException("Bins have different reference sequences");
            }
            if (b.getBinNumber() != binNumber) {
                throw new IllegalArgumentException("Bins have different numbers");
            }
            allChunks.addAll(b.getChunkList());
        }
        Collections.sort(allChunks);
        Bin bin = new Bin(referenceSequence, binNumber);
        for (Chunk newChunk : allChunks) {
            long chunkStart = newChunk.getChunkStart();
            long chunkEnd = newChunk.getChunkEnd();
            List oldChunks = bin.getChunkList();
            if (!bin.containsChunks()) {
                bin.addInitialChunk(newChunk);
                continue;
            }
            Chunk lastChunk = bin.getLastChunk();
            if (BlockCompressedFilePointerUtil.areInSameOrAdjacentBlocks((long)lastChunk.getChunkEnd(), (long)chunkStart)) {
                lastChunk.setChunkEnd(chunkEnd);
                continue;
            }
            oldChunks.add(newChunk);
            bin.setLastChunk(newChunk);
        }
        return bin;
    }

    private static BAMIndexMetaData mergeMetaData(List<BAMIndexMetaData> metaDataList, long[] offsets) {
        ArrayList<BAMIndexMetaData> newMetadataList = new ArrayList<BAMIndexMetaData>();
        for (int i = 0; i < metaDataList.size(); ++i) {
            newMetadataList.add(VirtualShiftUtil.shift(metaDataList.get(i), offsets[i]));
        }
        return BAMIndexMerger.mergeMetaData(newMetadataList);
    }

    private static BAMIndexMetaData mergeMetaData(List<BAMIndexMetaData> metaDataList) {
        long firstOffset = Long.MAX_VALUE;
        long lastOffset = Long.MIN_VALUE;
        long alignedRecordCount = 0L;
        long unalignedRecordCount = 0L;
        for (BAMIndexMetaData metaData : metaDataList) {
            if (metaData.getFirstOffset() != -1L) {
                firstOffset = Math.min(firstOffset, metaData.getFirstOffset());
            }
            if (metaData.getLastOffset() != 0L) {
                lastOffset = Math.max(lastOffset, metaData.getLastOffset());
            }
            alignedRecordCount += (long)metaData.getAlignedRecordCount();
            unalignedRecordCount += (long)metaData.getUnalignedRecordCount();
        }
        if (firstOffset == Long.MAX_VALUE) {
            firstOffset = -1L;
        }
        if (lastOffset == Long.MIN_VALUE) {
            lastOffset = -1L;
        }
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>();
        chunkList.add(new Chunk(firstOffset, lastOffset));
        chunkList.add(new Chunk(alignedRecordCount, unalignedRecordCount));
        return new BAMIndexMetaData(chunkList);
    }

    public static LinearIndex mergeLinearIndexes(int referenceSequence, List<LinearIndex> linearIndexes, long[] offsets) {
        int maxIndex = -1;
        for (LinearIndex li : linearIndexes) {
            if (li.getIndexStart() != 0) {
                throw new IllegalArgumentException("Cannot merge linear indexes that don't all start at zero");
            }
            maxIndex = Math.max(maxIndex, li.size());
        }
        if (maxIndex == -1) {
            throw new IllegalArgumentException("Error merging linear indexes");
        }
        long[] entries = new long[maxIndex];
        Arrays.fill(entries, -1L);
        block1: for (int i = 0; i < maxIndex; ++i) {
            for (int liIndex = 0; liIndex < linearIndexes.size(); ++liIndex) {
                LinearIndex li = linearIndexes.get(liIndex);
                long[] indexEntries = li.getIndexEntries();
                if (i >= indexEntries.length || indexEntries[i] == -1L) continue;
                entries[i] = VirtualShiftUtil.shift(indexEntries[i], offsets[liIndex]);
                continue block1;
            }
        }
        long lastNonZeroOffset = 0L;
        for (int i = 0; i < maxIndex; ++i) {
            if (entries[i] == -1L) {
                entries[i] = lastNonZeroOffset;
                continue;
            }
            lastNonZeroOffset = entries[i];
        }
        return new LinearIndex(referenceSequence, 0, entries);
    }
}

