/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SBIIndex;
import htsjdk.samtools.SBIIndexWriter;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.Log;
import java.io.OutputStream;

public final class SBIIndexMerger {
    private static final Log log = Log.getInstance(SBIIndexMerger.class);
    private SBIIndexWriter indexWriter;
    private long granularity = -1L;
    private long offset;
    private long recordCount;
    private long finalVirtualOffset;

    public SBIIndexMerger(OutputStream out, long headerLength) {
        this.indexWriter = new SBIIndexWriter(out);
        this.offset = headerLength;
    }

    public void processIndex(SBIIndex index) {
        long[] virtualOffsets = index.getVirtualOffsets();
        for (int i = 0; i < virtualOffsets.length - 1; ++i) {
            this.indexWriter.writeVirtualOffset(SBIIndexMerger.shiftVirtualFilePointer(virtualOffsets[i], this.offset));
        }
        this.finalVirtualOffset = SBIIndexMerger.shiftVirtualFilePointer(virtualOffsets[virtualOffsets.length - 1], this.offset);
        SBIIndex.Header header = index.getHeader();
        this.offset += header.getFileLength();
        this.recordCount += header.getTotalNumberOfRecords();
        if (this.granularity == -1L) {
            this.granularity = header.getGranularity();
        } else if (this.granularity > 0L && this.granularity != header.getGranularity()) {
            log.warn(new Object[]{"Different granularities so setting to 0 (unspecified)"});
            this.granularity = 0L;
        }
    }

    private static long shiftVirtualFilePointer(long virtualFilePointer, long offset) {
        long blockAddress = BlockCompressedFilePointerUtil.getBlockAddress((long)virtualFilePointer);
        int blockOffset = BlockCompressedFilePointerUtil.getBlockOffset((long)virtualFilePointer);
        return BlockCompressedFilePointerUtil.makeFilePointer((long)(blockAddress + offset), (int)blockOffset);
    }

    public void finish(long dataFileLength) {
        SBIIndex.Header header = new SBIIndex.Header(dataFileLength, SBIIndexWriter.EMPTY_MD5, SBIIndexWriter.EMPTY_UUID, this.recordCount, this.granularity);
        this.indexWriter.finish(header, this.finalVirtualOffset);
    }
}

