/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.tabix;

import htsjdk.samtools.BAMIndexMerger;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndex;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TabixIndexMerger {
    public static void merge(List<Long> partLengths, List<SeekableStream> tbiStreams, OutputStream tbiOut) throws IOException {
        if (tbiStreams.isEmpty()) {
            throw new IllegalArgumentException("Cannot merge zero tabix files");
        }
        ArrayList<TabixIndex> tbis = new ArrayList<TabixIndex>();
        for (SeekableStream tbiStream : tbiStreams) {
            tbis.add(new TabixIndex((InputStream)new BlockCompressedInputStream(tbiStream)));
        }
        TabixFormat formatSpec = ((TabixIndex)tbis.get(0)).getFormatSpec();
        List sequenceNames = ((TabixIndex)tbis.get(0)).getSequenceNames();
        for (TabixIndex tbi : tbis) {
            if (!tbi.getFormatSpec().equals((Object)formatSpec)) {
                throw new IllegalArgumentException(String.format("Cannot merge tabix files with different formats, %s and %s.", tbi.getFormatSpec(), formatSpec));
            }
            if (tbi.getSequenceNames().equals(sequenceNames)) continue;
            throw new IllegalArgumentException(String.format("Cannot merge tabix files with different sequence names, %s and %s.", tbi.getSequenceNames(), sequenceNames));
        }
        long[] offsets = partLengths.stream().mapToLong(i -> i).toArray();
        Arrays.parallelPrefix(offsets, (a, b) -> a + b);
        ArrayList<BinningIndexContent> mergedBinningIndexContentList = new ArrayList<BinningIndexContent>();
        for (int ref = 0; ref < sequenceNames.size(); ++ref) {
            ArrayList<BinningIndexContent> binningIndexContentList = new ArrayList<BinningIndexContent>();
            for (TabixIndex tbi : tbis) {
                binningIndexContentList.add(TabixIndexMerger.getBinningIndexContent(tbi, ref));
            }
            BinningIndexContent binningIndexContent = TabixIndexMerger.mergeBinningIndexContent(ref, binningIndexContentList, offsets);
            mergedBinningIndexContentList.add(binningIndexContent);
        }
        TabixIndex tabixIndex = new TabixIndex(formatSpec, sequenceNames, mergedBinningIndexContentList.toArray(new BinningIndexContent[0]));
        LittleEndianOutputStream los = new LittleEndianOutputStream((OutputStream)new BlockCompressedOutputStream(tbiOut, (File)null));
        Object object = null;
        try {
            tabixIndex.write(los);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (los != null) {
                if (object != null) {
                    try {
                        los.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    los.close();
                }
            }
        }
    }

    public static BinningIndexContent[] getBinningIndexContents(TabixIndex tbi) {
        try {
            Field indices = TabixIndex.class.getDeclaredField("indices");
            indices.setAccessible(true);
            BinningIndexContent[] contents = (BinningIndexContent[])indices.get(tbi);
            return Arrays.copyOf(contents, contents.length);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static BinningIndexContent getBinningIndexContent(TabixIndex tbi, int ref) {
        return TabixIndexMerger.getBinningIndexContents(tbi)[ref];
    }

    private static BinningIndexContent mergeBinningIndexContent(int referenceSequence, List<BinningIndexContent> binningIndexContentList, long[] offsets) {
        ArrayList<BinningIndexContent.BinList> binLists = new ArrayList<BinningIndexContent.BinList>();
        ArrayList<LinearIndex> linearIndexes = new ArrayList<LinearIndex>();
        for (BinningIndexContent binningIndexContent : binningIndexContentList) {
            binLists.add(binningIndexContent.getBins());
            linearIndexes.add(binningIndexContent.getLinearIndex());
        }
        return new BinningIndexContent(referenceSequence, BAMIndexMerger.mergeBins(binLists, offsets), BAMIndexMerger.mergeLinearIndexes(referenceSequence, linearIndexes, offsets));
    }
}

