/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.BAMIndexMerger;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiMerger {
    private static final Logger logger = LoggerFactory.getLogger(BaiMerger.class);
    private final FileSystemWrapper fileSystemWrapper;

    public BaiMerger(FileSystemWrapper fileSystemWrapper) {
        this.fileSystemWrapper = fileSystemWrapper;
    }

    public void mergeParts(Configuration conf, String tempPartsDirectory, String outputFile, SAMFileHeader header, List<Long> partLengths) throws IOException {
        logger.info("Merging .bai files in temp directory {} to {}", (Object)tempPartsDirectory, (Object)outputFile);
        List<String> parts = this.fileSystemWrapper.listDirectory(conf, tempPartsDirectory);
        List<String> baiParts = this.getBaiParts(parts);
        if (partLengths.size() - 2 != baiParts.size()) {
            throw new IllegalArgumentException("Cannot merge different number of BAM and BAI files in " + tempPartsDirectory);
        }
        try (OutputStream out = this.fileSystemWrapper.create(conf, outputFile);){
            ArrayList<SeekableStream> baiStreams = new ArrayList<SeekableStream>();
            for (String baiPart : baiParts) {
                baiStreams.add(this.fileSystemWrapper.open(conf, baiPart));
            }
            BAMIndexMerger.merge(header, partLengths, baiStreams, out);
            for (SeekableStream stream : baiStreams) {
                stream.close();
            }
        }
        for (String baiPart : baiParts) {
            this.fileSystemWrapper.delete(conf, baiPart);
        }
        logger.info("Done merging .bai files");
    }

    private List<String> getBaiParts(List<String> parts) {
        return parts.stream().filter(f -> f.endsWith(".bai")).collect(Collectors.toList());
    }
}

