/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.SBIIndex;
import htsjdk.samtools.SBIIndexMerger;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SbiMerger {
    private static final Logger logger = LoggerFactory.getLogger(SbiMerger.class);
    private final FileSystemWrapper fileSystemWrapper;

    public SbiMerger(FileSystemWrapper fileSystemWrapper) {
        this.fileSystemWrapper = fileSystemWrapper;
    }

    public void mergeParts(Configuration conf, String tempPartsDirectory, String outputFile, long headerLength, long fileLength) throws IOException {
        logger.info("Merging .sbi files in temp directory {} to {}", (Object)tempPartsDirectory, (Object)outputFile);
        List<String> parts = this.fileSystemWrapper.listDirectory(conf, tempPartsDirectory);
        List filteredParts = parts.stream().filter(f -> f.endsWith(".sbi")).collect(Collectors.toList());
        try (OutputStream out = this.fileSystemWrapper.create(conf, outputFile);){
            SBIIndexMerger sbiIndexMerger = new SBIIndexMerger(out, headerLength);
            for (String sbiPartFile : filteredParts) {
                try (SeekableStream in = this.fileSystemWrapper.open(conf, sbiPartFile);){
                    sbiIndexMerger.processIndex(SBIIndex.load((InputStream)in));
                }
                this.fileSystemWrapper.delete(conf, sbiPartFile);
            }
            sbiIndexMerger.finish(fileLength);
        }
        logger.info("Done merging .sbi files");
    }
}

