/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.index.tabix.TabixIndexMerger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.TabixIndexWriteOption;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TbiMerger {
    private static final Logger logger = LoggerFactory.getLogger(TbiMerger.class);
    private final FileSystemWrapper fileSystemWrapper;

    public TbiMerger(FileSystemWrapper fileSystemWrapper) {
        this.fileSystemWrapper = fileSystemWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeParts(Configuration conf, String tempPartsDirectory, String outputFile, List<Long> partLengths) throws IOException {
        logger.info("Merging .tbi files in temp directory {} to {}", (Object)tempPartsDirectory, (Object)outputFile);
        List<String> parts = this.fileSystemWrapper.listDirectory(conf, tempPartsDirectory);
        List<String> tbiParts = this.getTbiParts(parts);
        if (partLengths.size() - 2 != tbiParts.size()) {
            throw new IllegalArgumentException("Cannot merge different number of VCF and TBI files in " + tempPartsDirectory);
        }
        ArrayList<SeekableStream> tbiStreams = new ArrayList<SeekableStream>();
        try (OutputStream out = this.fileSystemWrapper.create(conf, outputFile);){
            for (String tbiPart : tbiParts) {
                tbiStreams.add(this.fileSystemWrapper.open(conf, tbiPart));
            }
            TabixIndexMerger.merge(partLengths, tbiStreams, out);
        }
        finally {
            for (SeekableStream stream : tbiStreams) {
                stream.close();
            }
        }
        for (String tbiPart : tbiParts) {
            this.fileSystemWrapper.delete(conf, tbiPart);
        }
        logger.info("Done merging .tbi files");
    }

    private List<String> getTbiParts(List<String> parts) {
        return parts.stream().filter(f -> f.endsWith(TabixIndexWriteOption.getIndexExtension())).collect(Collectors.toList());
    }
}

