/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bgzf;

import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.formats.bgzf.BGZFSplitCompressionInputStream;
import org.disq_bio.disq.impl.formats.bgzf.BgzfBlockGuesser;

public class BGZFEnhancedGzipCodec
extends GzipCodec
implements SplittableCompressionCodec {
    public SplitCompressionInputStream createInputStream(InputStream seekableIn, Decompressor decompressor, long start, long end, SplittableCompressionCodec.READ_MODE readMode) throws IOException {
        if (!(seekableIn instanceof Seekable)) {
            throw new IOException("seekableIn must be an instance of " + Seekable.class.getName());
        }
        if (!BlockCompressedInputStream.isValidFile((InputStream)new BufferedInputStream(seekableIn))) {
            ((Seekable)seekableIn).seek(0L);
            final CompressionInputStream compressionInputStream = this.createInputStream(seekableIn, decompressor);
            return new SplitCompressionInputStream((InputStream)compressionInputStream, start, end){

                public int read(byte[] b, int off, int len) throws IOException {
                    return compressionInputStream.read(b, off, len);
                }

                public void resetState() throws IOException {
                    compressionInputStream.resetState();
                }

                public int read() throws IOException {
                    return compressionInputStream.read();
                }
            };
        }
        String source = ((Object)((Object)this)).toString();
        HadoopFileSystemWrapper.SeekableHadoopStream<InputStream> ss = new HadoopFileSystemWrapper.SeekableHadoopStream<InputStream>(seekableIn, end, source);
        BgzfBlockGuesser splitGuesser = new BgzfBlockGuesser(ss, null);
        BgzfBlockGuesser.BgzfBlock bgzfBlock = splitGuesser.guessNextBGZFPos(start, end);
        long adjustedStart = bgzfBlock != null ? bgzfBlock.pos : end;
        ((Seekable)seekableIn).seek(adjustedStart);
        return new BGZFSplitCompressionInputStream(seekableIn, adjustedStart, end);
    }
}

