/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.cram;

import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.impl.file.FileSystemWrapper;

public class CramReferenceSourceBuilder {
    public static CRAMReferenceSource build(FileSystemWrapper fileSystemWrapper, Configuration conf, String referenceSourcePath) throws IOException {
        SeekableStream refIn = fileSystemWrapper.open(conf, referenceSourcePath);
        try (SeekableStream indexIn = fileSystemWrapper.open(conf, referenceSourcePath + ".fai");){
            FastaSequenceIndex index = new FastaSequenceIndex((InputStream)indexIn);
            ReferenceSequenceFile refSeqFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((String)referenceSourcePath, (SeekableStream)refIn, (FastaSequenceIndex)index);
            ReferenceSource referenceSource = new ReferenceSource(refSeqFile);
            return referenceSource;
        }
    }
}

