/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.sam;

import java.util.function.Function;
import org.disq_bio.disq.FileCardinalityWriteOption;
import org.disq_bio.disq.ReadsFormatWriteOption;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.formats.bam.BamSource;
import org.disq_bio.disq.impl.formats.cram.CramSource;
import org.disq_bio.disq.impl.formats.sam.AbstractSamSource;
import org.disq_bio.disq.impl.formats.sam.SamSource;

public enum SamFormat {
    BAM(".bam", ".bai", BamSource::new),
    CRAM(".cram", ".crai", CramSource::new),
    SAM(".sam", null, fileSystemWrapper -> new SamSource());

    private final String extension;
    private final String indexExtension;
    private final Function<FileSystemWrapper, AbstractSamSource> sourceProvider;

    private SamFormat(String extension, String indexExtension, Function<FileSystemWrapper, AbstractSamSource> sourceProvider) {
        this.extension = extension;
        this.indexExtension = indexExtension;
        this.sourceProvider = sourceProvider;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getIndexExtension() {
        return this.indexExtension;
    }

    public AbstractSamSource createAbstractSamSource(FileSystemWrapper fileSystemWrapper) {
        return this.sourceProvider.apply(fileSystemWrapper);
    }

    public boolean fileMatches(String path) {
        return path.endsWith(this.extension);
    }

    public ReadsFormatWriteOption toFormatWriteOption() {
        return ReadsFormatWriteOption.valueOf(this.name());
    }

    public static SamFormat fromFormatWriteOption(ReadsFormatWriteOption formatWriteOption) {
        return SamFormat.valueOf(formatWriteOption.name());
    }

    public static SamFormat fromExtension(String extension) {
        for (SamFormat format : SamFormat.values()) {
            if (!extension.equals(format.extension)) continue;
            return format;
        }
        return null;
    }

    public static SamFormat fromPath(String path) {
        for (SamFormat format : SamFormat.values()) {
            if (!path.endsWith(format.extension)) continue;
            return format;
        }
        return null;
    }

    public static FileCardinalityWriteOption fileCardinalityWriteOptionFromPath(String path) {
        return SamFormat.fromPath(path) == null ? FileCardinalityWriteOption.MULTIPLE : FileCardinalityWriteOption.SINGLE;
    }

    public static ReadsFormatWriteOption formatWriteOptionFromPath(String path) {
        SamFormat samFormat = SamFormat.fromPath(path);
        return samFormat == null ? null : samFormat.toFormatWriteOption();
    }
}

