/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.vcf;

import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class VcfOutputFormat
extends FileOutputFormat<Void, VariantContext> {
    private static VCFHeader header;
    private static String extension;

    public static void setHeader(VCFHeader vcfHeader) {
        header = vcfHeader;
    }

    public static void setExtension(String extension) {
        VcfOutputFormat.extension = extension;
    }

    public RecordWriter<Void, VariantContext> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Path file = this.getDefaultWorkFile(taskAttemptContext, extension);
        return new VcfRecordWriter(taskAttemptContext.getConfiguration(), file, header, extension);
    }

    static class VcfRecordWriter
    extends RecordWriter<Void, VariantContext> {
        private final VariantContextWriter variantContextWriter;

        public VcfRecordWriter(Configuration conf, Path file, VCFHeader header, String extension) throws IOException {
            boolean compressed;
            FSDataOutputStream out = file.getFileSystem(conf).create(file);
            boolean bl = compressed = extension.endsWith(".bgz") || extension.endsWith(".gz");
            if (compressed) {
                out = new BlockCompressedOutputStream((OutputStream)out, (File)null);
            }
            this.variantContextWriter = new VariantContextWriterBuilder().clearOptions().setOutputVCFStream((OutputStream)out).build();
            this.variantContextWriter.writeHeader(header);
        }

        public void write(Void ignore, VariantContext variantContext) {
            this.variantContextWriter.add(variantContext);
        }

        public void close(TaskAttemptContext taskAttemptContext) {
            this.variantContextWriter.close();
        }
    }
}

