/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.vcf;

import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.TabixIndexWriteOption;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.HiddenFileFilter;
import org.disq_bio.disq.impl.file.Merger;
import org.disq_bio.disq.impl.file.TbiMerger;
import org.disq_bio.disq.impl.formats.vcf.AbstractVcfSink;
import org.disq_bio.disq.impl.formats.vcf.HeaderlessVcfOutputFormat;
import scala.Tuple2;

public class VcfSink
extends AbstractVcfSink {
    private FileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();

    @Override
    public void save(JavaSparkContext jsc, VCFHeader vcfHeader, JavaRDD<VariantContext> variants, String path, String tempPartsDirectory, List<String> indexesToEnable) throws IOException {
        Broadcast vcfHeaderBroadcast = jsc.broadcast((Object)vcfHeader);
        boolean compressed = path.endsWith(".bgz") || path.endsWith(".gz");
        boolean writeTbiFile = compressed && indexesToEnable.contains(TabixIndexWriteOption.getIndexExtension());
        variants.mapPartitions((FlatMapFunction & Serializable)readIterator -> {
            HeaderlessVcfOutputFormat.setHeader((VCFHeader)vcfHeaderBroadcast.getValue());
            HeaderlessVcfOutputFormat.setBlockCompress(compressed);
            HeaderlessVcfOutputFormat.setWriteTbiFile(writeTbiFile);
            return readIterator;
        }).mapToPair((PairFunction & Serializable)variantContext -> new Tuple2(null, variantContext)).saveAsNewAPIHadoopFile(tempPartsDirectory, Void.class, VariantContext.class, HeaderlessVcfOutputFormat.class, jsc.hadoopConfiguration());
        String headerFile = tempPartsDirectory + "/header" + (compressed ? ".bgz" : "");
        try (OutputStream headerOut = this.fileSystemWrapper.create(jsc.hadoopConfiguration(), headerFile);){
            OutputStream out = compressed ? new BlockCompressedOutputStream(headerOut, (File)null) : headerOut;
            VariantContextWriter writer = new VariantContextWriterBuilder().clearOptions().setOutputVCFStream(out).build();
            writer.writeHeader(vcfHeader);
            out.flush();
        }
        if (compressed) {
            String terminatorFile = tempPartsDirectory + "/terminator";
            OutputStream out = this.fileSystemWrapper.create(jsc.hadoopConfiguration(), terminatorFile);
            Object object = null;
            try {
                out.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
            }
            catch (Throwable writer) {
                object = writer;
                throw writer;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable writer) {
                            ((Throwable)object).addSuppressed(writer);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        List vcfParts = this.fileSystemWrapper.listDirectory(jsc.hadoopConfiguration(), tempPartsDirectory).stream().filter(new HiddenFileFilter()).collect(Collectors.toList());
        ArrayList<Long> partLengths = new ArrayList<Long>();
        for (String part : vcfParts) {
            partLengths.add(this.fileSystemWrapper.getFileLength(jsc.hadoopConfiguration(), part));
        }
        new Merger().mergeParts(jsc.hadoopConfiguration(), tempPartsDirectory, path);
        if (writeTbiFile) {
            new TbiMerger(this.fileSystemWrapper).mergeParts(jsc.hadoopConfiguration(), tempPartsDirectory, path + TabixIndexWriteOption.getIndexExtension(), partLengths);
        }
        this.fileSystemWrapper.delete(jsc.hadoopConfiguration(), tempPartsDirectory);
    }
}

