/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.vcf;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.impl.formats.vcf.AbstractVcfSink;
import org.disq_bio.disq.impl.formats.vcf.VcfFormat;
import org.disq_bio.disq.impl.formats.vcf.VcfOutputFormat;
import scala.Tuple2;

public class VcfSinkMultiple
extends AbstractVcfSink
implements Serializable {
    private String extension;

    public VcfSinkMultiple(VcfFormat vcfFormat) {
        this.extension = vcfFormat.getExtension();
    }

    @Override
    public void save(JavaSparkContext jsc, VCFHeader vcfHeader, JavaRDD<VariantContext> variants, String path, String tempPartsDirectory, List<String> indexesToEnable) {
        Broadcast headerBroadcast = jsc.broadcast((Object)vcfHeader);
        variants.mapPartitions((FlatMapFunction & Serializable)readIterator -> {
            VcfOutputFormat.setHeader((VCFHeader)headerBroadcast.getValue());
            VcfOutputFormat.setExtension(this.extension);
            return readIterator;
        }).mapToPair((PairFunction & Serializable)variantContext -> new Tuple2(null, variantContext)).saveAsNewAPIHadoopFile(path, Void.class, VariantContext.class, VcfOutputFormat.class, jsc.hadoopConfiguration());
    }
}

