/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinaryBAMIndexWriter;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.IndexMerger;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.VirtualShiftUtil;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BAMIndexMerger
extends IndexMerger<AbstractBAMFileIndex> {
    private static final int UNINITIALIZED_WINDOW = -1;
    private int numReferences;
    private final List<List<BAMIndexContent>> content = new ArrayList<List<BAMIndexContent>>();
    private long noCoordinateCount;

    public BAMIndexMerger(OutputStream out, long headerLength) {
        super(out, headerLength);
    }

    @Override
    public void processIndex(AbstractBAMFileIndex index, long partLength) {
        int ref;
        this.partLengths.add(partLength);
        if (this.content.isEmpty()) {
            this.numReferences = index.getNumberOfReferences();
            for (ref = 0; ref < this.numReferences; ++ref) {
                this.content.add(new ArrayList());
            }
        }
        if (index.getNumberOfReferences() != this.numReferences) {
            throw new IllegalArgumentException(String.format("Cannot merge BAI files with different number of references, %s and %s.", this.numReferences, index.getNumberOfReferences()));
        }
        for (ref = 0; ref < this.numReferences; ++ref) {
            List<BAMIndexContent> bamIndexContentList = this.content.get(ref);
            bamIndexContentList.add(index.getQueryResults(ref));
        }
        this.noCoordinateCount += index.getNoCoordinateCount().longValue();
    }

    @Override
    public void finish(long dataFileLength) {
        if (this.content.isEmpty()) {
            throw new IllegalArgumentException("Cannot merge zero BAI files");
        }
        long[] offsets = this.partLengths.stream().mapToLong(i -> i).toArray();
        Arrays.parallelPrefix(offsets, (a, b) -> a + b);
        try (BinaryBAMIndexWriter writer = new BinaryBAMIndexWriter(this.numReferences, this.out);){
            for (int ref = 0; ref < this.numReferences; ++ref) {
                List<BAMIndexContent> bamIndexContentList = this.content.get(ref);
                BAMIndexContent bamIndexContent = BAMIndexMerger.mergeBAMIndexContent(ref, bamIndexContentList, offsets);
                writer.writeReference(bamIndexContent);
            }
            writer.writeNoCoordinateRecordCount(Long.valueOf(this.noCoordinateCount));
        }
    }

    public static AbstractBAMFileIndex openIndex(SeekableStream stream, SAMSequenceDictionary dictionary) {
        return new CachingBAMFileIndex(stream, dictionary);
    }

    private static BAMIndexContent mergeBAMIndexContent(int referenceSequence, List<BAMIndexContent> bamIndexContentList, long[] offsets) {
        ArrayList<BinningIndexContent.BinList> binLists = new ArrayList<BinningIndexContent.BinList>();
        ArrayList<BAMIndexMetaData> metaDataList = new ArrayList<BAMIndexMetaData>();
        ArrayList<LinearIndex> linearIndexes = new ArrayList<LinearIndex>();
        for (BAMIndexContent bamIndexContent : bamIndexContentList) {
            binLists.add(bamIndexContent.getBins());
            metaDataList.add(bamIndexContent.getMetaData());
            linearIndexes.add(bamIndexContent.getLinearIndex());
        }
        return new BAMIndexContent(referenceSequence, BAMIndexMerger.mergeBins(binLists, offsets), BAMIndexMerger.mergeMetaData(metaDataList, offsets), BAMIndexMerger.mergeLinearIndexes(referenceSequence, linearIndexes, offsets));
    }

    public static BinningIndexContent.BinList mergeBins(List<BinningIndexContent.BinList> binLists, long[] offsets) {
        ArrayList<Bin> mergedBins = new ArrayList<Bin>();
        int maxBinNumber = binLists.stream().mapToInt(bl -> bl.maxBinNumber).max().orElse(0);
        int commonNonNullBins = 0;
        for (int i = 0; i <= maxBinNumber; ++i) {
            ArrayList<Bin> nonNullBins = new ArrayList<Bin>();
            for (int j = 0; j < binLists.size(); ++j) {
                BinningIndexContent.BinList binList = binLists.get(j);
                Bin bin = VirtualShiftUtil.shift(binList.getBin(i), offsets[j]);
                if (bin == null) continue;
                nonNullBins.add(bin);
            }
            if (nonNullBins.isEmpty()) continue;
            mergedBins.add(BAMIndexMerger.mergeBins(nonNullBins));
            commonNonNullBins += nonNullBins.size() - 1;
        }
        int numberOfNonNullBins = binLists.stream().mapToInt(BinningIndexContent.BinList::getNumberOfNonNullBins).sum() - commonNonNullBins;
        return new BinningIndexContent.BinList(mergedBins.toArray(new Bin[0]), numberOfNonNullBins);
    }

    private static Bin mergeBins(List<Bin> bins) {
        if (bins.isEmpty()) {
            throw new IllegalArgumentException("Cannot merge empty bins");
        }
        if (bins.size() == 1) {
            return bins.get(0);
        }
        int referenceSequence = bins.get(0).getReferenceSequence();
        int binNumber = bins.get(0).getBinNumber();
        ArrayList allChunks = new ArrayList();
        for (Bin b : bins) {
            if (b.getReferenceSequence() != referenceSequence) {
                throw new IllegalArgumentException("Bins have different reference sequences");
            }
            if (b.getBinNumber() != binNumber) {
                throw new IllegalArgumentException("Bins have different numbers");
            }
            allChunks.addAll(b.getChunkList());
        }
        Collections.sort(allChunks);
        Bin bin = new Bin(referenceSequence, binNumber);
        for (Chunk newChunk : allChunks) {
            long chunkStart = newChunk.getChunkStart();
            long chunkEnd = newChunk.getChunkEnd();
            List oldChunks = bin.getChunkList();
            if (!bin.containsChunks()) {
                bin.addInitialChunk(newChunk);
                continue;
            }
            Chunk lastChunk = bin.getLastChunk();
            if (BlockCompressedFilePointerUtil.areInSameOrAdjacentBlocks((long)lastChunk.getChunkEnd(), (long)chunkStart)) {
                lastChunk.setChunkEnd(chunkEnd);
                continue;
            }
            oldChunks.add(newChunk);
            bin.setLastChunk(newChunk);
        }
        return bin;
    }

    private static BAMIndexMetaData mergeMetaData(List<BAMIndexMetaData> metaDataList, long[] offsets) {
        ArrayList<BAMIndexMetaData> newMetadataList = new ArrayList<BAMIndexMetaData>();
        for (int i = 0; i < metaDataList.size(); ++i) {
            newMetadataList.add(VirtualShiftUtil.shift(metaDataList.get(i), offsets[i]));
        }
        return BAMIndexMerger.mergeMetaData(newMetadataList);
    }

    private static BAMIndexMetaData mergeMetaData(List<BAMIndexMetaData> metaDataList) {
        long firstOffset = Long.MAX_VALUE;
        long lastOffset = Long.MIN_VALUE;
        long alignedRecordCount = 0L;
        long unalignedRecordCount = 0L;
        for (BAMIndexMetaData metaData : metaDataList) {
            if (metaData.getFirstOffset() != -1L) {
                firstOffset = Math.min(firstOffset, metaData.getFirstOffset());
            }
            if (metaData.getLastOffset() != 0L) {
                lastOffset = Math.max(lastOffset, metaData.getLastOffset());
            }
            alignedRecordCount += (long)metaData.getAlignedRecordCount();
            unalignedRecordCount += (long)metaData.getUnalignedRecordCount();
        }
        if (firstOffset == Long.MAX_VALUE) {
            firstOffset = -1L;
        }
        if (lastOffset == Long.MIN_VALUE) {
            lastOffset = -1L;
        }
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>();
        chunkList.add(new Chunk(firstOffset, lastOffset));
        chunkList.add(new Chunk(alignedRecordCount, unalignedRecordCount));
        return new BAMIndexMetaData(chunkList);
    }

    public static LinearIndex mergeLinearIndexes(int referenceSequence, List<LinearIndex> linearIndexes, long[] offsets) {
        int maxIndex = -1;
        for (LinearIndex li : linearIndexes) {
            if (li.getIndexStart() != 0) {
                throw new IllegalArgumentException("Cannot merge linear indexes that don't all start at zero");
            }
            maxIndex = Math.max(maxIndex, li.size());
        }
        if (maxIndex == -1) {
            throw new IllegalArgumentException("Error merging linear indexes");
        }
        long[] entries = new long[maxIndex];
        Arrays.fill(entries, -1L);
        block1: for (int i = 0; i < maxIndex; ++i) {
            for (int liIndex = 0; liIndex < linearIndexes.size(); ++liIndex) {
                LinearIndex li = linearIndexes.get(liIndex);
                long[] indexEntries = li.getIndexEntries();
                if (i >= indexEntries.length || indexEntries[i] == -1L) continue;
                entries[i] = VirtualShiftUtil.shift(indexEntries[i], offsets[liIndex]);
                continue block1;
            }
        }
        long lastNonZeroOffset = 0L;
        for (int i = 0; i < maxIndex; ++i) {
            if (entries[i] == -1L) {
                entries[i] = lastNonZeroOffset;
                continue;
            }
            lastNonZeroOffset = entries[i];
        }
        return new LinearIndex(referenceSequence, 0, entries);
    }
}

