/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.IOUtils;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystemWrapper
implements FileSystemWrapper {
    private static final Logger logger = LoggerFactory.getLogger(HadoopFileSystemWrapper.class);
    private static final boolean TRACK_UNCLOSED_STREAMS = false;

    @Override
    public boolean usesNio() {
        return false;
    }

    @Override
    public String normalize(Configuration conf, String path) throws IOException {
        Path p = new Path(path);
        FileSystem fileSystem = p.getFileSystem(conf);
        return fileSystem.makeQualified(p).toString();
    }

    @Override
    public SeekableStream open(Configuration conf, String path) throws IOException {
        Path p = new Path(path);
        FileSystem fileSystem = p.getFileSystem(conf);
        long len = fileSystem.getFileStatus(p).getLen();
        return new SeekableBufferedStream(new SeekableHadoopStream<FSDataInputStream>(fileSystem.open(p), len, path));
    }

    @Override
    public OutputStream create(Configuration conf, String path) throws IOException {
        Path p = new Path(path);
        FileSystem fileSystem = p.getFileSystem(conf);
        return fileSystem.create(p);
    }

    @Override
    public boolean delete(Configuration conf, String path) throws IOException {
        Path p = new Path(path);
        FileSystem fileSystem = p.getFileSystem(conf);
        return fileSystem.delete(p, true);
    }

    @Override
    public boolean exists(Configuration conf, String path) throws IOException {
        Path p = new Path(path);
        FileSystem fileSystem = p.getFileSystem(conf);
        return fileSystem.exists(p);
    }

    @Override
    public long getFileLength(Configuration conf, String path) throws IOException {
        Path p = new Path(path);
        FileSystem fileSystem = p.getFileSystem(conf);
        return fileSystem.getFileStatus(p).getLen();
    }

    @Override
    public boolean isDirectory(Configuration conf, String path) throws IOException {
        Path p = new Path(path);
        FileSystem fileSystem = p.getFileSystem(conf);
        return fileSystem.isDirectory(p);
    }

    @Override
    public List<String> listDirectory(Configuration conf, String path) throws IOException {
        Path p = new Path(path);
        FileSystem fileSystem = p.getFileSystem(conf);
        return Arrays.stream(fileSystem.listStatus(p)).map(fs -> fs.getPath().toUri().toString()).sorted().collect(Collectors.toList());
    }

    @Override
    public List<FileSystemWrapper.FileStatus> listDirectoryStatus(Configuration conf, String path) throws IOException {
        Path p = new Path(path);
        FileSystem fileSystem = p.getFileSystem(conf);
        return Arrays.stream(fileSystem.listStatus(p)).map(fs -> new FileSystemWrapper.FileStatus(fs.getPath().toUri().toString(), fs.getLen())).sorted().collect(Collectors.toList());
    }

    @Override
    public void concat(Configuration conf, List<String> parts, String path) throws IOException {
        Path tmp = new Path(new Path(parts.get(0)).getParent(), "output");
        FileSystem fileSystem = tmp.getFileSystem(conf);
        fileSystem.create(tmp).close();
        try {
            HadoopFileSystemWrapper.concat(parts, tmp, fileSystem);
            Path target = new Path(path);
            if (fileSystem.exists(target)) {
                fileSystem.delete(target, true);
            }
            fileSystem.rename(tmp, target);
        }
        catch (UnsupportedOperationException e) {
            logger.warn("Concat not supported, merging serially");
            try (OutputStream out = this.create(conf, path);){
                for (String part : parts) {
                    try (SeekableStream in = this.open(conf, part);){
                        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf, (boolean)false);
                    }
                    fileSystem.delete(new Path(part), false);
                }
            }
            fileSystem.delete(tmp, false);
        }
    }

    static void concat(List<String> parts, Path outputPath, FileSystem filesystem) throws IOException {
        Path[] fsParts = parts.stream().map(Path::new).collect(Collectors.toList()).toArray(new Path[parts.size()]);
        filesystem.concat(new Path(outputPath.toUri()), fsParts);
    }

    public static class SeekableHadoopStream<S extends InputStream>
    extends SeekableStream {
        private static Set<SeekableHadoopStream> unclosedStreams = new LinkedHashSet<SeekableHadoopStream>();
        private final S in;
        private final long length;
        private final String source;
        private final String constructionStackTrace;

        public SeekableHadoopStream(S seekableIn, long length, String source) {
            this.in = seekableIn;
            this.length = length;
            this.source = source;
            this.constructionStackTrace = this.getStackTrace();
        }

        private String getStackTrace() {
            return null;
        }

        public long length() {
            return this.length;
        }

        public long position() throws IOException {
            return ((Seekable)this.in).getPos();
        }

        public void seek(long position) throws IOException {
            ((Seekable)this.in).seek(position);
        }

        public int read() throws IOException {
            return ((InputStream)this.in).read();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return ((InputStream)this.in).read(buffer, offset, length);
        }

        public void close() throws IOException {
            ((InputStream)this.in).close();
        }

        public boolean eof() throws IOException {
            return ((Seekable)this.in).getPos() == this.length();
        }

        public String getSource() {
            return this.source.toString();
        }

        private static /* synthetic */ void lambda$static$1() {
            if (unclosedStreams.isEmpty()) {
                System.out.println("No dangling input streams");
            } else {
                System.out.println("Dangling input streams");
                unclosedStreams.forEach(s -> System.out.println(s.source + "\n" + s.constructionStackTrace));
            }
        }
    }
}

