/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.IndexMerger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexFileMerger<I, H> {
    private static final Logger logger = LoggerFactory.getLogger(IndexFileMerger.class);
    protected final FileSystemWrapper fileSystemWrapper;

    protected IndexFileMerger(FileSystemWrapper fileSystemWrapper) {
        this.fileSystemWrapper = fileSystemWrapper;
    }

    protected abstract String getIndexExtension();

    protected abstract IndexMerger<I> newIndexMerger(OutputStream var1, long var2);

    public void mergeParts(Configuration conf, String tempPartsDirectory, String outputFile, H header, List<Long> partLengths, long fileLength) throws IOException {
        logger.info("Merging {} files in temp directory {} to {}", new Object[]{this.getIndexExtension(), tempPartsDirectory, outputFile});
        List<String> parts = this.fileSystemWrapper.listDirectory(conf, tempPartsDirectory);
        List filteredParts = parts.stream().filter(f -> f.endsWith(this.getIndexExtension())).collect(Collectors.toList());
        if (partLengths.size() - 2 != filteredParts.size()) {
            throw new IllegalArgumentException("Cannot merge different number of BAM and BAI files in " + tempPartsDirectory);
        }
        int i = 0;
        ExecutorService executorService = Executors.newFixedThreadPool(8);
        try (OutputStream out = this.fileSystemWrapper.create(conf, outputFile);){
            IndexMerger<I> indexMerger = this.newIndexMerger(out, partLengths.get(i++));
            List callables = filteredParts.stream().map(part -> () -> this.readIndex(conf, (String)part, header)).collect(Collectors.toList());
            for (Future futureIndex : executorService.invokeAll(callables)) {
                indexMerger.processIndex(futureIndex.get(), partLengths.get(i++));
            }
            indexMerger.finish(fileLength);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        finally {
            executorService.shutdown();
        }
        logger.info("Done merging {} files", (Object)this.getIndexExtension());
    }

    protected abstract I readIndex(Configuration var1, String var2, H var3) throws IOException;
}

