/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HiddenFileFilter;

public class Merger {
    private final FileSystemWrapper fileSystemWrapper;

    public Merger(FileSystemWrapper fileSystemWrapper) {
        this.fileSystemWrapper = fileSystemWrapper;
    }

    public void mergeParts(Configuration conf, List<FileSystemWrapper.FileStatus> fileStatuses, String outputFile) throws IOException {
        List<String> parts = fileStatuses.stream().map(FileSystemWrapper.FileStatus::getPath).collect(Collectors.toList());
        this.fileSystemWrapper.concat(conf, parts, outputFile);
    }

    public void mergeParts(Configuration conf, String tempPartsDirectory, String outputFile) throws IOException {
        List<String> parts = this.fileSystemWrapper.listDirectory(conf, tempPartsDirectory);
        List<String> filteredParts = parts.stream().filter(new HiddenFileFilter()).collect(Collectors.toList());
        this.fileSystemWrapper.concat(conf, filteredParts, outputFile);
    }
}

