/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bgzf;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hadoop.io.IOUtils;

public class BgzfBlockGuesser
implements Closeable {
    protected static final int BGZF_MAGIC = 67668767;
    protected static final int BGZF_MAGIC_SUB = 148290;
    protected static final int BGZF_SUB_SIZE = 6;
    protected SeekableStream in;
    protected String path;
    protected final ByteBuffer buf;

    public BgzfBlockGuesser(SeekableStream in, String path) {
        this.in = in;
        this.path = path;
        this.buf = ByteBuffer.allocate(8);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public BgzfBlock guessNextBGZFPos(long p, long end) {
        try {
            while (true) {
                this.in.seek(p);
                IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                int n = this.buf.getInt(0);
                if (n != 67668767) {
                    p = n >>> 8 == 559903 ? ++p : (n >>> 16 == 35615 ? (p += 2L) : (p += 3L));
                    if (p < end) continue;
                    return null;
                }
                long p0 = p;
                this.in.seek(p += 10L);
                IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)2);
                int xlen = this.getUShort(0);
                long subEnd = (p += 2L) + (long)xlen;
                while (p < subEnd) {
                    IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                    if (this.buf.getInt(0) != 148290) {
                        this.in.seek(p += (long)(4 + this.getUShort(2)));
                        continue;
                    }
                    IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)2);
                    int bsize = this.getUShort(0);
                    p += 6L;
                    while (p < subEnd) {
                        this.in.seek(p);
                        IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                        p += (long)(4 + this.getUShort(2));
                    }
                    if (p != subEnd) break;
                    this.in.seek(p += (long)(bsize - xlen - 19 + 4));
                    IOUtils.readFully((InputStream)this.in, (byte[])this.buf.array(), (int)0, (int)4);
                    return new BgzfBlock(this.path, p0, (int)(p + 4L - p0), this.buf.getInt(0), end, this.in);
                }
                p = p0 + 4L;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    protected int getUShort(int idx) {
        return this.buf.getShort(idx) & 0xFFFF;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class BgzfBlock
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String path;
        public long pos;
        public int cSize;
        public int uSize;
        public long end;
        private transient SeekableStream in;

        public BgzfBlock(String pa, long p, int cs, int us, long e, SeekableStream in) {
            this.path = pa;
            this.pos = p;
            this.cSize = cs;
            this.uSize = us;
            this.end = e;
            this.in = in;
        }

        public void end() throws IOException {
            this.in.close();
        }

        public String toString() {
            return "BgzfBlock{path=" + this.path + ", pos=" + this.pos + ", cSize=" + this.cSize + ", uSize=" + this.uSize + ", end=" + this.end + '}';
        }
    }
}

