/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMIndexMerger;
import htsjdk.samtools.IndexMerger;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.seekablestream.ByteArraySeekableStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.IndexFileMerger;

public class BaiMerger
extends IndexFileMerger<AbstractBAMFileIndex, SAMFileHeader> {
    public BaiMerger(FileSystemWrapper fileSystemWrapper) {
        super(fileSystemWrapper);
    }

    @Override
    protected String getIndexExtension() {
        return ".bai";
    }

    @Override
    protected IndexMerger<AbstractBAMFileIndex> newIndexMerger(OutputStream out, long headerLength) {
        return new BAMIndexMerger(out, headerLength);
    }

    @Override
    protected AbstractBAMFileIndex readIndex(Configuration conf, String file, SAMFileHeader header) throws IOException {
        AbstractBAMFileIndex index;
        try (SeekableStream in = this.fileSystemWrapper.open(conf, file);){
            byte[] bytes = InputStreamUtils.readFully((InputStream)in);
            ByteArraySeekableStream allIn = new ByteArraySeekableStream(bytes);
            index = BAMIndexMerger.openIndex((SeekableStream)allIn, header.getSequenceDictionary());
        }
        this.fileSystemWrapper.delete(conf, file);
        return index;
    }
}

