/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bgzf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.formats.bgzf.BGZFCompressionOutputStream;
import org.disq_bio.disq.impl.formats.bgzf.BGZFSplitCompressionInputStream;
import org.disq_bio.disq.impl.formats.bgzf.BgzfBlockGuesser;

public class BGZFCodec
extends GzipCodec
implements SplittableCompressionCodec {
    public static final String DEFAULT_EXTENSION = ".bgz";

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new BGZFCompressionOutputStream(out);
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return this.createOutputStream(out);
    }

    public Class<? extends Compressor> getCompressorType() {
        return null;
    }

    public Compressor createCompressor() {
        return null;
    }

    public SplitCompressionInputStream createInputStream(InputStream seekableIn, Decompressor decompressor, long start, long end, SplittableCompressionCodec.READ_MODE readMode) throws IOException {
        String source = ((Object)((Object)this)).toString();
        HadoopFileSystemWrapper.SeekableHadoopStream<InputStream> ss = new HadoopFileSystemWrapper.SeekableHadoopStream<InputStream>(seekableIn, end, source);
        BgzfBlockGuesser splitGuesser = new BgzfBlockGuesser(ss, null);
        BgzfBlockGuesser.BgzfBlock bgzfBlock = splitGuesser.guessNextBGZFPos(start, end);
        long adjustedStart = bgzfBlock != null ? bgzfBlock.pos : end;
        ((Seekable)seekableIn).seek(adjustedStart);
        return new BGZFSplitCompressionInputStream(seekableIn, adjustedStart, end);
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }
}

