/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.sam;

import htsjdk.samtools.CRAMFileWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.formats.cram.CramReferenceSourceBuilder;
import org.disq_bio.disq.impl.formats.sam.SamFormat;

public class AnySamOutputFormat
extends FileOutputFormat<Void, SAMRecord> {
    private static SAMFileHeader header;
    private static SamFormat samFormat;
    private static String referenceSourcePath;

    public static void setHeader(SAMFileHeader samFileHeader) {
        header = samFileHeader;
    }

    public static void setSamFormat(SamFormat samFormat) {
        AnySamOutputFormat.samFormat = samFormat;
    }

    public static void setReferenceSourcePath(String referenceSourcePath) {
        AnySamOutputFormat.referenceSourcePath = referenceSourcePath;
    }

    public RecordWriter<Void, SAMRecord> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Path file = this.getDefaultWorkFile(taskAttemptContext, samFormat.getExtension());
        return new AnySamRecordWriter(taskAttemptContext.getConfiguration(), file, header, samFormat, referenceSourcePath);
    }

    static class AnySamRecordWriter
    extends RecordWriter<Void, SAMRecord> {
        private final SAMFileWriter samFileWriter;

        public AnySamRecordWriter(Configuration conf, Path file, SAMFileHeader header, SamFormat samFormat, String referenceSourcePath) throws IOException {
            FSDataOutputStream out = file.getFileSystem(conf).create(file);
            SAMFileWriterFactory writerFactory = new SAMFileWriterFactory().setUseAsyncIo(false);
            switch (samFormat) {
                case BAM: {
                    this.samFileWriter = writerFactory.makeBAMWriter(header, true, (OutputStream)out);
                    break;
                }
                case CRAM: {
                    HadoopFileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();
                    CRAMReferenceSource referenceSource = CramReferenceSourceBuilder.build(fileSystemWrapper, conf, referenceSourcePath);
                    this.samFileWriter = new CRAMFileWriter((OutputStream)out, referenceSource, header, null);
                    break;
                }
                case SAM: {
                    this.samFileWriter = writerFactory.makeSAMWriter(header, true, (OutputStream)out);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized format: " + (Object)((Object)samFormat));
                }
            }
        }

        public void write(Void ignore, SAMRecord samRecord) {
            this.samFileWriter.addAlignment(samRecord);
        }

        public void close(TaskAttemptContext taskAttemptContext) {
            this.samFileWriter.close();
        }
    }
}

