/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.sam;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.util.List;
import org.disq_bio.disq.HtsjdkReadsTraversalParameters;

class TraversalOverlapDetector<T extends Locatable>
extends OverlapDetector<T> {
    private final boolean traverseUnplacedUnmapped;

    public TraversalOverlapDetector(HtsjdkReadsTraversalParameters<T> traversalParameters) {
        super(0, 0);
        this.traverseUnplacedUnmapped = traversalParameters.getTraverseUnplacedUnmapped();
        if (traversalParameters.getIntervalsForTraversal() != null && !traversalParameters.getIntervalsForTraversal().isEmpty()) {
            List<T> intervals = traversalParameters.getIntervalsForTraversal();
            this.addAll(intervals, intervals);
        }
    }

    public boolean overlapsAny(Locatable locatable) {
        SAMRecord record;
        if (this.traverseUnplacedUnmapped && locatable instanceof SAMRecord && (record = (SAMRecord)locatable).getReadUnmappedFlag() && record.getAlignmentStart() == 0) {
            return true;
        }
        return super.overlapsAny(locatable);
    }
}

