/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.google.common.base.Preconditions;
import de.javakaffee.kryoserializers.CollectionsEmptyListSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonListSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.BAMRecord;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SBIIndex;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.FastaSequenceIndexEntry;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.util.Interval;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.CommonInfo;
import htsjdk.variant.variantcontext.FastGenotype;
import htsjdk.variant.variantcontext.GenotypeType;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.serializer.KryoRegistrator;
import org.disq_bio.disq.HtsjdkReadsTraversalParameters;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.NioFileSystemWrapper;
import org.disq_bio.disq.impl.formats.bam.BamRecordGuesserChecker;
import org.disq_bio.disq.impl.formats.bgzf.BgzfBlockGuesser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.mutable.WrappedArray;

public class DisqKryoRegistrator
implements KryoRegistrator {
    private final Logger logger = LoggerFactory.getLogger(DisqKryoRegistrator.class);

    public void registerClasses(Kryo kryo) {
        kryo.register(AlignmentBlock.class);
        kryo.register(BAMRecord.class);
        kryo.register(Chunk.class);
        kryo.register(Cigar.class);
        kryo.register(CigarElement.class);
        kryo.register(CigarOperator.class);
        kryo.register(SAMBinaryTagAndValue.class);
        kryo.register(SAMFileHeader.class);
        kryo.register(SAMFileHeader.GroupOrder.class);
        kryo.register(SAMFileHeader.SortOrder.class);
        kryo.register(SAMProgramRecord.class);
        kryo.register(SAMReadGroupRecord.class);
        kryo.register(SAMRecord.class);
        kryo.register(SAMSequenceDictionary.class);
        kryo.register(SAMSequenceRecord.class);
        kryo.register(SBIIndex.class);
        kryo.register(SBIIndex.Header.class);
        kryo.register(ValidationStringency.class);
        kryo.register(ReferenceSource.class);
        kryo.register(FastaSequenceIndex.class);
        kryo.register(FastaSequenceIndexEntry.class);
        kryo.register(IndexedFastaSequenceFile.class);
        kryo.register(Interval.class);
        kryo.register(Allele.class);
        kryo.register(CommonInfo.class);
        kryo.register(FastGenotype.class);
        kryo.register(GenotypeType.class);
        kryo.register(LazyGenotypesContext.class, (Serializer)new JavaSerializer());
        kryo.register(VariantContext.class);
        kryo.register(VariantContext.Type.class);
        kryo.register(VCFCompoundHeaderLine.SupportedHeaderLineType.class);
        kryo.register(VCFContigHeaderLine.class);
        kryo.register(VCFFilterHeaderLine.class);
        kryo.register(VCFFormatHeaderLine.class);
        kryo.register(VCFHeader.class);
        kryo.register(VCFHeaderLine.class);
        kryo.register(VCFHeaderLineCount.class);
        kryo.register(VCFHeaderLineType.class);
        kryo.register(VCFInfoHeaderLine.class);
        kryo.register(VCFSimpleHeaderLine.class);
        kryo.register(FileDescriptor.class);
        kryo.register(Object.class);
        kryo.register(Object[].class);
        kryo.register(ArrayList.class);
        kryo.register(Collections.EMPTY_LIST.getClass(), (Serializer)new CollectionsEmptyListSerializer());
        kryo.register(Collections.singletonList("").getClass(), (Serializer)new CollectionsSingletonListSerializer());
        kryo.register(HashMap.class);
        kryo.register(HashSet.class);
        kryo.register(LinkedHashMap.class);
        this.registerByName(kryo, "java.util.LinkedHashMap$Entry");
        this.registerByName(kryo, "java.util.LinkedHashMap$LinkedValueIterator");
        kryo.register(LinkedHashSet.class);
        kryo.register(TreeSet.class);
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
        kryo.register(FileCommitProtocol.TaskCommitMessage.class);
        kryo.register(HtsjdkReadsTraversalParameters.class);
        kryo.register(HadoopFileSystemWrapper.class, (Serializer)new Serializer<HadoopFileSystemWrapper>(){

            public void write(Kryo kryo, Output output, HadoopFileSystemWrapper fileSystemWrapper) {
            }

            public HadoopFileSystemWrapper read(Kryo kryo, Input input, Class<HadoopFileSystemWrapper> type) {
                return new HadoopFileSystemWrapper();
            }
        });
        kryo.register(NioFileSystemWrapper.class, (Serializer)new Serializer<NioFileSystemWrapper>(){

            public void write(Kryo kryo, Output output, NioFileSystemWrapper fileSystemWrapper) {
            }

            public NioFileSystemWrapper read(Kryo kryo, Input input, Class<NioFileSystemWrapper> type) {
                return new NioFileSystemWrapper();
            }
        });
        kryo.register(BamRecordGuesserChecker.RecordStartResult.class);
        kryo.register(BgzfBlockGuesser.BgzfBlock.class);
        this.registerByName(kryo, "scala.collection.immutable.Set$EmptySet$");
        kryo.register(WrappedArray.ofRef.class);
    }

    void registerByName(Kryo kryo, String className) {
        try {
            kryo.register(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            this.logger.debug("Unable to register class {} by name", (Object)e, (Object)className);
        }
    }

    public static final void registerDisqClasses(Kryo kryo) {
        Preconditions.checkNotNull((Object)kryo);
        new DisqKryoRegistrator().registerClasses(kryo);
    }
}

