/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CRAMCRAIIndexer;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.build.ContainerFactory;
import htsjdk.samtools.cram.build.Cram2SamRecordFactory;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.build.CramNormalizer;
import htsjdk.samtools.cram.build.Sam2CramRecordFactory;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.lossy.QualityScorePreservation;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceTracks;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SequenceUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CRAMContainerStreamWriter2 {
    private static final Version cramVersion = CramVersions.DEFAULT_CRAM_VERSION;
    static int DEFAULT_RECORDS_PER_SLICE = 10000;
    static int MIN_SINGLE_REF_RECORDS = 1000;
    protected final int recordsPerSlice = DEFAULT_RECORDS_PER_SLICE;
    private static final int DEFAULT_SLICES_PER_CONTAINER = 1;
    protected final int containerSize = this.recordsPerSlice * 1;
    private static final int REF_SEQ_INDEX_NOT_INITIALIZED = -3;
    private final SAMFileHeader samFileHeader;
    private final String cramID;
    private final OutputStream outputStream;
    private CRAMReferenceSource source;
    private final List<SAMRecord> samRecords = new ArrayList<SAMRecord>();
    private ContainerFactory containerFactory;
    private int refSeqIndex = -3;
    private static final Log log = Log.getInstance(CRAMContainerStreamWriter2.class);
    private boolean preserveReadNames = true;
    private QualityScorePreservation preservation = null;
    private boolean captureAllTags = true;
    private Set<String> captureTags = new TreeSet<String>();
    private Set<String> ignoreTags = new TreeSet<String>();
    private CRAMCRAIIndexer indexer;
    private long offset;

    public CRAMContainerStreamWriter2(OutputStream outputStream, OutputStream indexStream, CRAMReferenceSource source, SAMFileHeader samFileHeader, String cramId) {
        this.outputStream = outputStream;
        this.samFileHeader = samFileHeader;
        this.cramID = cramId;
        this.source = source;
        this.containerFactory = new ContainerFactory(samFileHeader, this.recordsPerSlice);
        if (indexStream != null) {
            this.indexer = new CRAMCRAIIndexer(indexStream, samFileHeader);
        }
    }

    public void writeAlignment(SAMRecord alignment) {
        if (this.shouldFlushContainer(alignment)) {
            this.flushContainer();
        }
        this.updateReferenceContext(alignment.getReferenceIndex());
        this.samRecords.add(alignment);
    }

    public void writeHeader(SAMFileHeader header) {
        this.offset = CramIO.writeHeader((Version)cramVersion, (OutputStream)this.outputStream, (SAMFileHeader)header, (String)this.cramID);
    }

    public void finish(boolean writeEOFContainer) {
        try {
            if (!this.samRecords.isEmpty()) {
                this.flushContainer();
            }
            if (writeEOFContainer) {
                CramIO.issueEOF((Version)cramVersion, (OutputStream)this.outputStream);
            }
            this.outputStream.flush();
            if (this.indexer != null) {
                this.indexer.finish();
            }
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean preserveReadNames) {
        this.preserveReadNames = preserveReadNames;
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        if (this.preservation == null) {
            this.preservation = new QualityScorePreservation("*8");
        }
        return this.preservation.getPreservationPolicies();
    }

    public boolean isCaptureAllTags() {
        return this.captureAllTags;
    }

    public void setCaptureAllTags(boolean captureAllTags) {
        this.captureAllTags = captureAllTags;
    }

    public Set<String> getCaptureTags() {
        return this.captureTags;
    }

    public void setCaptureTags(Set<String> captureTags) {
        this.captureTags = captureTags;
    }

    public Set<String> getIgnoreTags() {
        return this.ignoreTags;
    }

    public void setIgnoreTags(Set<String> ignoreTags) {
        this.ignoreTags = ignoreTags;
    }

    protected boolean shouldFlushContainer(SAMRecord nextRecord) {
        boolean sameRef;
        if (this.samRecords.isEmpty()) {
            this.refSeqIndex = nextRecord.getReferenceIndex();
            return false;
        }
        if (this.samRecords.size() >= this.containerSize) {
            return true;
        }
        if (this.samFileHeader.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            return false;
        }
        if (this.refSeqIndex != -1 && nextRecord.getReferenceIndex() == -1) {
            return true;
        }
        if (this.refSeqIndex == -2) {
            return false;
        }
        boolean bl = sameRef = this.refSeqIndex == nextRecord.getReferenceIndex();
        if (sameRef) {
            return false;
        }
        if (this.samRecords.size() > MIN_SINGLE_REF_RECORDS) {
            return true;
        }
        this.refSeqIndex = -2;
        return false;
    }

    private static void updateTracks(List<SAMRecord> samRecords, ReferenceTracks tracks) {
        for (SAMRecord samRecord : samRecords) {
            if (samRecord.getAlignmentStart() == 0) continue;
            int refPos = samRecord.getAlignmentStart();
            int readPos = 0;
            for (CigarElement cigarElement : samRecord.getCigar().getCigarElements()) {
                if (cigarElement.getOperator().consumesReferenceBases()) {
                    for (int elementIndex = 0; elementIndex < cigarElement.getLength(); ++elementIndex) {
                        tracks.addCoverage(refPos + elementIndex, 1);
                    }
                }
                switch (cigarElement.getOperator()) {
                    case M: 
                    case X: 
                    case EQ: {
                        for (int pos = readPos; pos < cigarElement.getLength(); ++pos) {
                            byte refBase;
                            byte readBase = samRecord.getReadBases()[readPos + pos];
                            if (readBase == (refBase = tracks.baseAt(refPos + pos))) continue;
                            tracks.addMismatches(refPos + pos, 1);
                        }
                        break;
                    }
                }
                readPos += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                refPos += cigarElement.getOperator().consumesReferenceBases() ? cigarElement.getLength() : 0;
            }
        }
    }

    protected void flushContainer() throws IllegalArgumentException {
        byte[] referenceBases;
        String refSeqName = null;
        switch (this.refSeqIndex) {
            case -2: {
                if (this.preservation != null && this.preservation.areReferenceTracksRequired()) {
                    throw new SAMException("Cannot apply reference-based lossy compression on non-coordinate sorted reads.");
                }
                referenceBases = new byte[]{};
                break;
            }
            case -1: {
                referenceBases = new byte[]{};
                break;
            }
            default: {
                SAMSequenceRecord sequence = this.samFileHeader.getSequence(this.refSeqIndex);
                referenceBases = this.source.getReferenceBases(sequence, true);
                refSeqName = sequence.getSequenceName();
            }
        }
        int start = 0;
        int stop = 0;
        for (SAMRecord r : this.samRecords) {
            if (r.getAlignmentStart() == 0) continue;
            if (start == 0) {
                start = r.getAlignmentStart();
            }
            start = Math.min(r.getAlignmentStart(), start);
            stop = Math.max(r.getAlignmentEnd(), stop);
        }
        ReferenceTracks tracks = null;
        if (this.preservation != null && this.preservation.areReferenceTracksRequired()) {
            tracks = new ReferenceTracks(this.refSeqIndex, refSeqName, referenceBases);
            tracks.ensureRange(start, stop - start + 1);
            CRAMContainerStreamWriter2.updateTracks(this.samRecords, tracks);
        }
        ArrayList<CramCompressionRecord> cramRecords = new ArrayList<CramCompressionRecord>(this.samRecords.size());
        Sam2CramRecordFactory sam2CramRecordFactory = new Sam2CramRecordFactory(referenceBases, this.samFileHeader, cramVersion);
        sam2CramRecordFactory.preserveReadNames = this.preserveReadNames;
        sam2CramRecordFactory.captureAllTags = this.captureAllTags;
        sam2CramRecordFactory.captureTags.addAll(this.captureTags);
        sam2CramRecordFactory.ignoreTags.addAll(this.ignoreTags);
        this.containerFactory.setPreserveReadNames(this.preserveReadNames);
        int index = 0;
        for (SAMRecord samRecord : this.samRecords) {
            if (samRecord.getReferenceIndex() != -1 && this.refSeqIndex != samRecord.getReferenceIndex()) {
                sam2CramRecordFactory.setRefBases(this.source.getReferenceBases(this.samFileHeader.getSequence(samRecord.getReferenceIndex().intValue()), true));
            }
            CramCompressionRecord cramRecord = sam2CramRecordFactory.createCramRecord(samRecord);
            cramRecord.index = ++index;
            cramRecord.alignmentStart = samRecord.getAlignmentStart();
            cramRecords.add(cramRecord);
            if (this.preservation != null) {
                this.preservation.addQualityScores(samRecord, cramRecord, tracks);
                continue;
            }
            if (cramRecord.qualityScores == SAMRecord.NULL_QUALS) continue;
            cramRecord.setForcePreserveQualityScores(true);
        }
        if (sam2CramRecordFactory.getBaseCount() < 3L * sam2CramRecordFactory.getFeatureCount()) {
            log.warn(new Object[]{"Abnormally high number of mismatches, possibly wrong reference."});
        }
        if (this.samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate) {
            TreeMap primaryMateMap = new TreeMap();
            TreeMap secondaryMateMap = new TreeMap();
            for (CramCompressionRecord r : cramRecords) {
                if (!r.isMultiFragment()) {
                    r.setDetached(true);
                    r.setHasMateDownStream(false);
                    r.recordsToNextFragment = -1;
                    r.next = null;
                    r.previous = null;
                    continue;
                }
                String name = r.readName;
                Object mateMap = r.isSecondaryAlignment() ? secondaryMateMap : primaryMateMap;
                CramCompressionRecord mate = (CramCompressionRecord)mateMap.get(name);
                if (mate == null) {
                    mateMap.put(name, r);
                    continue;
                }
                CramCompressionRecord prev = mate;
                while (prev.next != null) {
                    prev = prev.next;
                }
                prev.recordsToNextFragment = r.index - prev.index - 1;
                prev.next = r;
                r.previous = prev;
                r.previous.setHasMateDownStream(true);
                r.setHasMateDownStream(false);
                r.setDetached(false);
                r.previous.setDetached(false);
            }
            for (CramCompressionRecord cramRecord : cramRecords) {
                if (cramRecord.next == null || cramRecord.previous != null) continue;
                CramCompressionRecord last = cramRecord;
                while (last.next != null) {
                    last = last.next;
                }
                if (cramRecord.isFirstSegment() && last.isLastSegment()) {
                    int templateLength = CramNormalizer.computeInsertSize((CramCompressionRecord)cramRecord, (CramCompressionRecord)last);
                    if (cramRecord.templateSize == templateLength) {
                        last = cramRecord.next;
                        while (last.next != null && last.templateSize == -templateLength) {
                            last = last.next;
                        }
                        if (last.templateSize == -templateLength) continue;
                        CRAMContainerStreamWriter2.detach(cramRecord);
                        continue;
                    }
                    CRAMContainerStreamWriter2.detach(cramRecord);
                    continue;
                }
                CRAMContainerStreamWriter2.detach(cramRecord);
            }
            for (CramCompressionRecord cramRecord : primaryMateMap.values()) {
                if (cramRecord.next != null) continue;
                cramRecord.setDetached(true);
                cramRecord.setHasMateDownStream(false);
                cramRecord.recordsToNextFragment = -1;
                cramRecord.next = null;
                cramRecord.previous = null;
            }
            for (CramCompressionRecord cramRecord : secondaryMateMap.values()) {
                if (cramRecord.next != null) continue;
                cramRecord.setDetached(true);
                cramRecord.setHasMateDownStream(false);
                cramRecord.recordsToNextFragment = -1;
                cramRecord.next = null;
                cramRecord.previous = null;
            }
        } else {
            for (CramCompressionRecord cramRecord : cramRecords) {
                cramRecord.setDetached(true);
            }
        }
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            Cram2SamRecordFactory f = new Cram2SamRecordFactory(this.samFileHeader);
            for (int i = 0; i < this.samRecords.size(); ++i) {
                SAMRecord restoredSamRecord = f.create((CramCompressionRecord)cramRecords.get(i));
                assert (restoredSamRecord.getAlignmentStart() == this.samRecords.get(i).getAlignmentStart());
                assert (restoredSamRecord.getReferenceName().equals(this.samRecords.get(i).getReferenceName()));
                if (!restoredSamRecord.getReadString().equals(this.samRecords.get(i).getReadString())) {
                    byte[] originalReadBases = this.samRecords.get(i).getReadString().getBytes();
                    String originalReadBasesUpperCaseIupacNoDot = new String(SequenceUtil.toBamReadBasesInPlace((byte[])originalReadBases));
                    assert (restoredSamRecord.getReadString().equals(originalReadBasesUpperCaseIupacNoDot));
                }
                assert (restoredSamRecord.getBaseQualityString().equals(this.samRecords.get(i).getBaseQualityString()));
            }
        }
        Container container = this.containerFactory.buildContainer(cramRecords);
        for (Slice slice : container.slices) {
            slice.setRefMD5(referenceBases);
        }
        container.offset = this.offset;
        this.offset += (long)ContainerIO.writeContainer((Version)cramVersion, (Container)container, (OutputStream)this.outputStream);
        if (this.indexer != null) {
            this.indexer.processContainer(container);
        }
        this.samRecords.clear();
        this.refSeqIndex = -3;
    }

    private static void detach(CramCompressionRecord cramRecord) {
        do {
            cramRecord.setDetached(true);
            cramRecord.setHasMateDownStream(false);
            cramRecord.recordsToNextFragment = -1;
        } while ((cramRecord = cramRecord.next) != null);
    }

    private void updateReferenceContext(int samRecordReferenceIndex) {
        if (this.refSeqIndex == -2) {
            return;
        }
        if (this.refSeqIndex == -3) {
            this.refSeqIndex = samRecordReferenceIndex;
        } else if (this.refSeqIndex != samRecordReferenceIndex) {
            this.refSeqIndex = -2;
        }
    }
}

