/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.SeekableStream;

public class CachingBAMFileIndexOptimized
extends CachingBAMFileIndex {
    public CachingBAMFileIndexOptimized(SeekableStream stream, SAMSequenceDictionary dictionary) {
        super(stream, dictionary);
    }

    protected BAMIndexContent query(int referenceSequence, int startPos, int endPos) {
        this.seek(4L);
        int sequenceCount = this.readInteger();
        if (referenceSequence >= sequenceCount) {
            return null;
        }
        this.skipToSequence(referenceSequence);
        int binCount = this.readInteger();
        if (binCount == 0) {
            return null;
        }
        return super.query(referenceSequence, startPos, endPos);
    }

    private void skipToSequence(int sequenceIndex) {
        int startSequenceIndex;
        if (this.sequenceIndexes[sequenceIndex] != -1L) {
            this.seek(this.sequenceIndexes[sequenceIndex]);
            return;
        }
        if (sequenceIndex > 0 && this.sequenceIndexes[sequenceIndex - 1] != -1L) {
            this.seek(this.sequenceIndexes[sequenceIndex - 1]);
            startSequenceIndex = sequenceIndex - 1;
        } else {
            startSequenceIndex = 0;
        }
        for (int i = startSequenceIndex; i < sequenceIndex; ++i) {
            int nBins = this.readInteger();
            for (int j = 0; j < nBins; ++j) {
                this.readInteger();
                int nChunks = this.readInteger();
                this.skipBytes(16 * nChunks);
            }
            int nLinearBins = this.readInteger();
            this.skipBytes(8 * nLinearBins);
        }
        this.sequenceIndexes[sequenceIndex] = this.position();
    }
}

