/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Bin;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.index.tabix.TabixIndex;
import htsjdk.tribble.index.tabix.TabixIndexMerger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

public class TabixPlainText {
    public static void main(String[] args) throws IOException {
        TabixPlainText.textIndexTbi(new File(args[0]));
    }

    public static File textIndexTbi(File tbi) throws IOException {
        File textTbi = new File(tbi.toString() + ".txt");
        try (PrintWriter pw = new PrintWriter(textTbi);){
            TabixPlainText.dump(pw, new TabixIndex((InputStream)new BlockCompressedInputStream((InputStream)new FileInputStream(tbi))));
        }
        return textTbi;
    }

    public static void dump(PrintWriter pw, TabixIndex tbi) {
        BinningIndexContent[] binningIndexContents;
        for (BinningIndexContent content : binningIndexContents = TabixIndexMerger.getBinningIndexContents(tbi)) {
            if (content == null) continue;
            TabixPlainText.writeReference(pw, content);
        }
    }

    private static void writeReference(PrintWriter pw, BinningIndexContent content) {
        Bin bin;
        int size;
        int reference = content.getReferenceSequence();
        BinningIndexContent.BinList bins = content.getBins();
        int n = size = bins == null ? 0 : content.getNumberOfNonNullBins();
        if (size == 0) {
            pw.println("Reference " + reference + " has n_bin=0");
            pw.println("Reference " + reference + " has n_intv=0");
            return;
        }
        Iterator iterator = bins.iterator();
        while (iterator.hasNext() && (bin = (Bin)iterator.next()).getBinNumber() != 37450) {
            if (bin.getChunkList() == null) {
                pw.println("  Ref " + reference + " bin " + bin.getBinNumber() + " has no binArray");
                continue;
            }
            List chunkList = bin.getChunkList();
            if (chunkList == null) {
                pw.println("  Ref " + reference + " bin " + bin.getBinNumber() + " has no chunkList");
                continue;
            }
            pw.print("  Ref " + reference + " bin " + bin.getBinNumber() + " has n_chunk= " + chunkList.size());
            if (chunkList.isEmpty()) {
                pw.println();
            }
            for (Chunk c : chunkList) {
                pw.println("     Chunk: " + c.toString() + " start: " + Long.toString(c.getChunkStart(), 16) + " end: " + Long.toString(c.getChunkEnd(), 16));
            }
        }
        LinearIndex linearIndex = content.getLinearIndex();
        if (linearIndex == null || linearIndex.getIndexEntries() == null) {
            pw.println("Reference " + reference + " has n_intv= 0");
            return;
        }
        long[] entries = linearIndex.getIndexEntries();
        int indexStart = linearIndex.getIndexStart();
        int n_intv = entries.length + indexStart;
        pw.println("Reference " + reference + " has n_intv= " + n_intv);
        for (int k = 0; k < entries.length; ++k) {
            if (entries[k] == 0L) continue;
            pw.println("  Ref " + reference + " ioffset for " + (k + indexStart) + " is " + Long.toString(entries[k]));
        }
        pw.flush();
    }
}

