/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.Bin;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.util.ArrayList;

public class VirtualShiftUtil {
    static long shift(long virtualFilePointer, long offset) {
        if (virtualFilePointer == -1L) {
            return -1L;
        }
        long blockAddress = BlockCompressedFilePointerUtil.getBlockAddress((long)virtualFilePointer);
        int blockOffset = BlockCompressedFilePointerUtil.getBlockOffset((long)virtualFilePointer);
        return BlockCompressedFilePointerUtil.makeFilePointer((long)(blockAddress + offset), (int)blockOffset);
    }

    static Chunk shift(Chunk chunk, long offset) {
        return new Chunk(VirtualShiftUtil.shift(chunk.getChunkStart(), offset), VirtualShiftUtil.shift(chunk.getChunkEnd(), offset));
    }

    static Bin shift(Bin bin, long offset) {
        if (bin == null) {
            return null;
        }
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>();
        for (Chunk chunk : bin.getChunkList()) {
            chunkList.add(VirtualShiftUtil.shift(chunk, offset));
        }
        Bin newBin = new Bin(bin.getReferenceSequence(), bin.getBinNumber());
        newBin.setChunkList(chunkList);
        newBin.setLastChunk((Chunk)chunkList.get(chunkList.size() - 1));
        return newBin;
    }

    static BAMIndexMetaData shift(BAMIndexMetaData metaData, long offset) {
        long lastOffset;
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>();
        long firstOffset = metaData.getFirstOffset();
        if (firstOffset != -1L) {
            firstOffset = VirtualShiftUtil.shift(firstOffset, offset);
        }
        if ((lastOffset = metaData.getLastOffset()) != 0L) {
            lastOffset = VirtualShiftUtil.shift(lastOffset, offset);
        }
        chunkList.add(new Chunk(firstOffset, lastOffset));
        chunkList.add(new Chunk((long)metaData.getAlignedRecordCount(), (long)metaData.getUnalignedRecordCount()));
        return new BAMIndexMetaData(chunkList);
    }
}

