/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq;

import java.util.function.Function;
import org.disq_bio.disq.ReadsFormatWriteOption;
import org.disq_bio.disq.VariantsFormatWriteOption;
import org.disq_bio.disq.WriteOption;
import org.disq_bio.disq.impl.formats.sam.AbstractSamSink;
import org.disq_bio.disq.impl.formats.sam.AnySamSinkMultiple;
import org.disq_bio.disq.impl.formats.sam.SamFormat;
import org.disq_bio.disq.impl.formats.vcf.AbstractVcfSink;
import org.disq_bio.disq.impl.formats.vcf.VcfFormat;
import org.disq_bio.disq.impl.formats.vcf.VcfSink;
import org.disq_bio.disq.impl.formats.vcf.VcfSinkMultiple;

public enum FileCardinalityWriteOption implements WriteOption
{
    SINGLE(ReadsFormatWriteOption::createAbstractSamSink, variantsFormatWriteOption -> new VcfSink()),
    MULTIPLE(readsFormatWriteOption -> new AnySamSinkMultiple(SamFormat.fromFormatWriteOption(readsFormatWriteOption)), variantsFormatWriteOption -> new VcfSinkMultiple(VcfFormat.fromFormatWriteOption(variantsFormatWriteOption)));

    private final transient Function<ReadsFormatWriteOption, AbstractSamSink> samSinkProvider;
    private final transient Function<VariantsFormatWriteOption, AbstractVcfSink> vcfSinkProvider;

    private FileCardinalityWriteOption(Function<ReadsFormatWriteOption, AbstractSamSink> samSinkProvider, Function<VariantsFormatWriteOption, AbstractVcfSink> vcfSinkProvider) {
        this.samSinkProvider = samSinkProvider;
        this.vcfSinkProvider = vcfSinkProvider;
    }

    AbstractSamSink getAbstractSamSink(ReadsFormatWriteOption readsFormatWriteOption) {
        return this.samSinkProvider.apply(readsFormatWriteOption);
    }

    AbstractVcfSink getAbstractVcfSink(VariantsFormatWriteOption variantsFormatWriteOption) {
        return this.vcfSinkProvider.apply(variantsFormatWriteOption);
    }
}

