/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bam;

import htsjdk.samtools.BAMSBIIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SBIIndex;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.HtsjdkReadsRddStorage;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.NioFileSystemWrapper;
import org.disq_bio.disq.impl.formats.SerializableHadoopConfiguration;
import org.disq_bio.disq.impl.formats.bam.BamRecordGuesser;
import org.disq_bio.disq.impl.formats.bgzf.BgzfBlockGuesser;
import org.disq_bio.disq.impl.formats.bgzf.BgzfBlockSource;
import scala.Tuple2;

public class BamRecordGuesserChecker
implements Serializable {
    private final FileSystemWrapper fileSystemWrapper;

    public BamRecordGuesserChecker(FileSystemWrapper fileSystemWrapper) {
        this.fileSystemWrapper = fileSystemWrapper;
    }

    public BamRecordGuesserChecker(boolean useNio) {
        this(useNio ? new NioFileSystemWrapper() : new HadoopFileSystemWrapper());
    }

    SBIIndex getSBIIndex(Configuration conf, String bamFile) throws IOException {
        Throwable throwable;
        SeekableStream in;
        String sbiFile = bamFile + ".sbi";
        if (!this.fileSystemWrapper.exists(conf, sbiFile)) {
            in = this.fileSystemWrapper.open(conf, bamFile);
            throwable = null;
            try (OutputStream out = this.fileSystemWrapper.create(conf, sbiFile);){
                BAMSBIIndexer.createIndex((SeekableStream)in, (OutputStream)out, (long)1L);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        in = this.fileSystemWrapper.open(conf, sbiFile);
        throwable = null;
        try {
            SBIIndex sBIIndex = SBIIndex.load((InputStream)in);
            return sBIIndex;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (in != null) {
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    in.close();
                }
            }
        }
    }

    public JavaPairRDD<Long, RecordStartResult> check(JavaSparkContext jsc, String path, int splitSize) throws IOException {
        return this.check(jsc, path, splitSize, this.getSBIIndex(jsc.hadoopConfiguration(), path));
    }

    public JavaPairRDD<Long, RecordStartResult> check(JavaSparkContext jsc, String path, int splitSize, SBIIndex sbiIndex) throws IOException {
        SAMFileHeader header = HtsjdkReadsRddStorage.makeDefault(jsc).read(path).getHeader();
        Broadcast indexBroadcast = jsc.broadcast((Object)sbiIndex);
        SerializableHadoopConfiguration confSer = new SerializableHadoopConfiguration(jsc.hadoopConfiguration());
        return new BgzfBlockSource(this.fileSystemWrapper).getBgzfBlocks(jsc, path, splitSize).mapPartitionsToPair((PairFlatMapFunction & Serializable)bgzfBlockIterator -> {
            SBIIndex index = (SBIIndex)indexBroadcast.getValue();
            long granularity = index.getGranularity();
            long[] virtualOffsets = index.getVirtualOffsets();
            try (SeekableStream in = this.fileSystemWrapper.open(confSer.getConf(), path);){
                BamRecordGuesser bamRecordGuesser = new BamRecordGuesser(in, header.getSequenceDictionary().size(), header);
                ArrayList<Tuple2> mismatches = new ArrayList<Tuple2>();
                while (bgzfBlockIterator.hasNext()) {
                    BgzfBlockGuesser.BgzfBlock block = (BgzfBlockGuesser.BgzfBlock)bgzfBlockIterator.next();
                    if (granularity == 1L) {
                        for (int up = 0; up < block.uSize; ++up) {
                            boolean isRecordStart;
                            long vPos = BlockCompressedFilePointerUtil.makeFilePointer((long)block.pos, (int)up);
                            boolean isActualRecordStart = Arrays.binarySearch(virtualOffsets, vPos) >= 0;
                            if (isActualRecordStart == (isRecordStart = bamRecordGuesser.checkRecordStart(vPos))) continue;
                            if (isRecordStart) {
                                mismatches.add(new Tuple2((Object)vPos, (Object)RecordStartResult.FALSE_POSITIVE));
                                continue;
                            }
                            mismatches.add(new Tuple2((Object)vPos, (Object)RecordStartResult.FALSE_NEGATIVE));
                        }
                        continue;
                    }
                    TreeSet<Long> virtualOffsetsSet = new TreeSet<Long>(Arrays.stream(virtualOffsets).boxed().collect(Collectors.toList()));
                    for (Long vPos : virtualOffsetsSet.subSet(block.pos, block.end)) {
                        boolean isRecordStart = bamRecordGuesser.checkRecordStart(vPos);
                        if (isRecordStart) continue;
                        mismatches.add(new Tuple2((Object)vPos, (Object)RecordStartResult.FALSE_NEGATIVE));
                    }
                }
                Iterator iterator = mismatches.iterator();
                return iterator;
            }
        });
    }

    public static enum RecordStartResult {
        FALSE_POSITIVE,
        FALSE_NEGATIVE;

    }
}

