/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.vcf;

import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.tabix.AllRefsTabixIndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndex;
import htsjdk.tribble.index.tabix.TabixIndexMerger;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;

public class StreamBasedTabixIndexCreator
extends AllRefsTabixIndexCreator {
    private final OutputStream out;

    public StreamBasedTabixIndexCreator(SAMSequenceDictionary sequenceDictionary, TabixFormat formatSpec, OutputStream out) {
        super(sequenceDictionary, formatSpec);
        this.out = out;
    }

    @Override
    public Index finalizeIndex(long finalFilePosition) {
        Index index = super.finalizeIndex(finalFilePosition);
        TabixIndex tabixIndex = (TabixIndex)index;
        return new StreamBasedTabixIndex(tabixIndex.getFormatSpec(), tabixIndex.getSequenceNames(), TabixIndexMerger.getBinningIndexContents(tabixIndex), this.out);
    }

    static class StreamBasedTabixIndex
    extends TabixIndex {
        private final OutputStream out;

        StreamBasedTabixIndex(TabixFormat formatSpec, List<String> sequenceNames, BinningIndexContent[] indices, OutputStream out) {
            super(formatSpec, sequenceNames, indices);
            this.out = out;
        }

        public void writeBasedOnFeaturePath(Path featurePath) throws IOException {
            try (LittleEndianOutputStream los = new LittleEndianOutputStream((OutputStream)new BlockCompressedOutputStream(this.out, (Path)null));){
                this.write(los);
            }
        }
    }
}

