/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.IndexMerger;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.CRAIIndex;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class CRAIIndexMerger
extends IndexMerger<CRAIIndex> {
    private GZIPOutputStream compressedOut;
    private long offset;

    public CRAIIndexMerger(OutputStream out, long headerLength) throws IOException {
        super(out, headerLength);
        this.compressedOut = new GZIPOutputStream(new BufferedOutputStream(out));
        this.offset = headerLength;
    }

    @Override
    public void processIndex(CRAIIndex index, long partLength) {
        index.getCRAIEntries().forEach(e -> CRAIIndexMerger.shift(e, this.offset).writeToStream((OutputStream)this.compressedOut));
        this.offset += partLength;
    }

    private static CRAIEntry shift(CRAIEntry entry, long offset) {
        return new CRAIEntry(entry.getSequenceId(), entry.getAlignmentStart(), entry.getAlignmentSpan(), entry.getContainerStartByteOffset() + offset, entry.getSliceByteOffsetFromCompressionHeaderStart(), entry.getSliceByteSize());
    }

    @Override
    public void finish(long dataFileLength) throws IOException {
        this.compressedOut.flush();
        this.compressedOut.close();
    }
}

