/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import java.io.IOException;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class FileSplitInputFormat
extends FileInputFormat<Void, FileSplit> {
    public RecordReader<Void, FileSplit> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new FileSplitRecordReader();
    }

    static class FileSplitRecordReader
    extends RecordReader<Void, FileSplit> {
        private FileSplit split;
        private boolean hasNext = true;
        private FileSplit current = null;

        FileSplitRecordReader() {
        }

        public void initialize(InputSplit split, TaskAttemptContext context) {
            this.split = (FileSplit)split;
        }

        public boolean nextKeyValue() {
            if (this.hasNext) {
                this.current = this.split;
                this.hasNext = false;
                return true;
            }
            this.current = null;
            return false;
        }

        public Void getCurrentKey() {
            return null;
        }

        public FileSplit getCurrentValue() {
            return this.current;
        }

        public float getProgress() {
            return this.hasNext ? 0.0f : 1.0f;
        }

        public void close() throws IOException {
        }
    }
}

