/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.SeekableByteChannelPrefetcher;

public class NioFileSystemWrapper
implements FileSystemWrapper {
    private static final int PREFETCHER_BUFFER_SIZE_MB = 4;

    @Override
    public boolean usesNio() {
        return true;
    }

    @Override
    public String normalize(Configuration conf, String path) {
        return NioFileSystemWrapper.asPath(path).toAbsolutePath().normalize().toString();
    }

    @Override
    public SeekableStream open(Configuration conf, String path) throws IOException {
        Function<SeekableByteChannel, SeekableByteChannel> prefetcherWrapper = channel -> {
            try {
                return SeekableByteChannelPrefetcher.addPrefetcher(4, channel);
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        };
        return new SeekablePathStream(NioFileSystemWrapper.asPath(path), prefetcherWrapper);
    }

    @Override
    public OutputStream create(Configuration conf, String path) throws IOException {
        return Files.newOutputStream(NioFileSystemWrapper.asPath(path), new OpenOption[0]);
    }

    @Override
    public boolean delete(Configuration conf, String path) throws IOException {
        return Files.deleteIfExists(NioFileSystemWrapper.asPath(path));
    }

    @Override
    public boolean exists(Configuration conf, String path) {
        return Files.isRegularFile(NioFileSystemWrapper.asPath(path), new LinkOption[0]);
    }

    @Override
    public long getFileLength(Configuration conf, String path) throws IOException {
        return Files.size(NioFileSystemWrapper.asPath(path));
    }

    @Override
    public boolean isDirectory(Configuration conf, String path) throws IOException {
        return Files.isDirectory(NioFileSystemWrapper.asPath(path), new LinkOption[0]);
    }

    @Override
    public List<String> listDirectory(Configuration conf, String path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FileSystemWrapper.FileStatus> listDirectoryStatus(Configuration conf, String path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void concat(Configuration conf, List<String> parts, String path) throws IOException {
        try (OutputStream out = this.create(conf, path);){
            for (String part : parts) {
                Path src = NioFileSystemWrapper.asPath(part);
                Files.copy(src, out);
                Files.delete(src);
            }
        }
    }

    private static Path asPath(URI uri) {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                throw e;
            }
            try {
                return FileSystems.newFileSystem(uri, new HashMap(), cl).provider().getPath(uri);
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot create filesystem for " + uri, ex);
            }
        }
    }

    public static Path asPath(String path) {
        URI uri = URI.create(path);
        return uri.getScheme() == null ? Paths.get(path, new String[0]) : NioFileSystemWrapper.asPath(uri);
    }
}

