/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bam;

import htsjdk.samtools.BAMFileWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.BaiWriteOption;
import org.disq_bio.disq.SbiWriteOption;
import org.disq_bio.disq.impl.file.BaiMerger;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.HiddenFileFilter;
import org.disq_bio.disq.impl.file.Merger;
import org.disq_bio.disq.impl.file.SbiMerger;
import org.disq_bio.disq.impl.formats.bam.HeaderlessBamOutputFormat;
import org.disq_bio.disq.impl.formats.sam.AbstractSamSink;
import scala.Tuple2;

public class BamSink
extends AbstractSamSink {
    private FileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();

    @Override
    public void save(JavaSparkContext jsc, SAMFileHeader header, JavaRDD<SAMRecord> reads, String path, String referenceSourcePath, String tempPartsDirectory, long sbiIndexGranularity, List<String> indexesToEnable) throws IOException {
        Broadcast headerBroadcast = jsc.broadcast((Object)header);
        boolean writeSbiFile = indexesToEnable.contains(SbiWriteOption.getIndexExtension());
        boolean writeBaiFile = header.getSortOrder() == SAMFileHeader.SortOrder.coordinate && indexesToEnable.contains(BaiWriteOption.getIndexExtension());
        Configuration conf = jsc.hadoopConfiguration();
        reads.mapPartitions((FlatMapFunction & Serializable)readIterator -> {
            HeaderlessBamOutputFormat.setHeader((SAMFileHeader)headerBroadcast.getValue());
            HeaderlessBamOutputFormat.setWriteSbiFile(writeSbiFile);
            HeaderlessBamOutputFormat.setWriteBaiFile(writeBaiFile);
            HeaderlessBamOutputFormat.setSbiIndexGranularity(sbiIndexGranularity);
            return readIterator;
        }).mapToPair((PairFunction & Serializable)samRecord -> new Tuple2(null, samRecord)).saveAsNewAPIHadoopFile(tempPartsDirectory, Void.class, SAMRecord.class, HeaderlessBamOutputFormat.class, conf);
        String headerFile = tempPartsDirectory + "/header";
        try (OutputStream out = this.fileSystemWrapper.create(conf, headerFile);){
            BAMFileWriter.writeHeader((OutputStream)out, (SAMFileHeader)header);
        }
        String terminatorFile = tempPartsDirectory + "/terminator";
        try (OutputStream out = this.fileSystemWrapper.create(conf, terminatorFile);){
            out.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
        }
        List<FileSystemWrapper.FileStatus> bamParts = this.fileSystemWrapper.listDirectoryStatus(conf, tempPartsDirectory).stream().filter(fs -> new HiddenFileFilter().test(fs.getPath())).collect(Collectors.toList());
        List<Long> partLengths = bamParts.stream().mapToLong(FileSystemWrapper.FileStatus::getLength).boxed().collect(Collectors.toList());
        new Merger(this.fileSystemWrapper).mergeParts(conf, bamParts, path);
        long fileLength = this.fileSystemWrapper.getFileLength(conf, path);
        if (writeSbiFile) {
            new SbiMerger(this.fileSystemWrapper).mergeParts(conf, tempPartsDirectory, path + ".sbi", header, partLengths, fileLength);
        }
        if (writeBaiFile) {
            new BaiMerger(this.fileSystemWrapper).mergeParts(conf, tempPartsDirectory, path + ".bai", header, partLengths, fileLength);
        }
        this.fileSystemWrapper.delete(conf, tempPartsDirectory);
    }
}

