/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.cram;

import htsjdk.samtools.CRAMCRAIIndexer;
import htsjdk.samtools.CRAMContainerStreamWriter;
import htsjdk.samtools.CRAMIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.formats.cram.CramReferenceSourceBuilder;

public class CramOutputFormat
extends FileOutputFormat<Void, SAMRecord> {
    private static SAMFileHeader header;
    private static String referenceSourcePath;
    private static boolean writeCraiFile;

    public static void setHeader(SAMFileHeader samFileHeader) {
        header = samFileHeader;
    }

    public static void setReferenceSourcePath(String referenceSourcePath) {
        CramOutputFormat.referenceSourcePath = referenceSourcePath;
    }

    public static void setWriteCraiFile(boolean writeCraiFile) {
        CramOutputFormat.writeCraiFile = writeCraiFile;
    }

    public RecordWriter<Void, SAMRecord> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Path file = this.getDefaultWorkFile(taskAttemptContext, "");
        Path craiFile = writeCraiFile ? new Path(file.getParent(), "." + file.getName() + ".crai") : null;
        return new CramRecordWriter(taskAttemptContext.getConfiguration(), file, header, referenceSourcePath, craiFile);
    }

    static class CramRecordWriter
    extends RecordWriter<Void, SAMRecord> {
        private final OutputStream out;
        private final CRAMContainerStreamWriter cramWriter;

        public CramRecordWriter(Configuration conf, Path file, SAMFileHeader header, String referenceSourcePath, Path craiFile) throws IOException {
            this.out = file.getFileSystem(conf).create(file);
            HadoopFileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();
            CRAMReferenceSource referenceSource = CramReferenceSourceBuilder.build(fileSystemWrapper, conf, referenceSourcePath);
            FSDataOutputStream indexStream = craiFile != null ? craiFile.getFileSystem(conf).create(craiFile) : null;
            this.cramWriter = new CRAMContainerStreamWriter(this.out, referenceSource, header, file.toString(), (CRAMIndexer)(indexStream == null ? null : new CRAMCRAIIndexer((OutputStream)indexStream, header)));
        }

        public void write(Void ignore, SAMRecord samRecord) {
            this.cramWriter.writeAlignment(samRecord);
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException {
            this.cramWriter.finish(false);
            this.out.close();
        }
    }
}

