/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.cram;

import htsjdk.samtools.CRAMContainerStreamWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.CraiWriteOption;
import org.disq_bio.disq.impl.file.CraiMerger;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.HiddenFileFilter;
import org.disq_bio.disq.impl.file.Merger;
import org.disq_bio.disq.impl.formats.cram.CramOutputFormat;
import org.disq_bio.disq.impl.formats.cram.CramReferenceSourceBuilder;
import org.disq_bio.disq.impl.formats.sam.AbstractSamSink;
import scala.Tuple2;

public class CramSink
extends AbstractSamSink {
    private FileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();

    @Override
    public void save(JavaSparkContext jsc, SAMFileHeader header, JavaRDD<SAMRecord> reads, String path, String referenceSourcePath, String tempPartsDirectory, long sbiIndexGranularity, List<String> indexesToEnable) throws IOException {
        Object referenceSource;
        Broadcast headerBroadcast = jsc.broadcast((Object)header);
        boolean writeCraiFile = header.getSortOrder() == SAMFileHeader.SortOrder.coordinate && indexesToEnable.contains(CraiWriteOption.getIndexExtension());
        Configuration conf = jsc.hadoopConfiguration();
        reads.mapPartitions((FlatMapFunction & Serializable)readIterator -> {
            CramOutputFormat.setHeader((SAMFileHeader)headerBroadcast.getValue());
            CramOutputFormat.setReferenceSourcePath(referenceSourcePath);
            CramOutputFormat.setWriteCraiFile(writeCraiFile);
            return readIterator;
        }).mapToPair((PairFunction & Serializable)samRecord -> new Tuple2(null, samRecord)).saveAsNewAPIHadoopFile(tempPartsDirectory, Void.class, SAMRecord.class, CramOutputFormat.class, conf);
        String headerFile = tempPartsDirectory + "/header";
        try (OutputStream out = this.fileSystemWrapper.create(conf, headerFile);){
            referenceSource = CramReferenceSourceBuilder.build(this.fileSystemWrapper, conf, referenceSourcePath);
            this.writeHeader(header, out, headerFile, (CRAMReferenceSource)referenceSource);
        }
        String terminatorFile = tempPartsDirectory + "/terminator";
        OutputStream out = this.fileSystemWrapper.create(conf, terminatorFile);
        referenceSource = null;
        try {
            CramIO.issueEOF((Version)CramVersions.DEFAULT_CRAM_VERSION, (OutputStream)out);
        }
        catch (Throwable throwable) {
            referenceSource = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (referenceSource != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)referenceSource).addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
        List<FileSystemWrapper.FileStatus> cramParts = this.fileSystemWrapper.listDirectoryStatus(conf, tempPartsDirectory).stream().filter(fs -> new HiddenFileFilter().test(fs.getPath())).collect(Collectors.toList());
        List<Long> partLengths = cramParts.stream().mapToLong(FileSystemWrapper.FileStatus::getLength).boxed().collect(Collectors.toList());
        new Merger(this.fileSystemWrapper).mergeParts(conf, cramParts, path);
        if (writeCraiFile) {
            long fileLength = this.fileSystemWrapper.getFileLength(conf, path);
            new CraiMerger(this.fileSystemWrapper).mergeParts(conf, tempPartsDirectory, path + ".crai", header, partLengths, fileLength);
        }
        this.fileSystemWrapper.delete(conf, tempPartsDirectory);
    }

    private void writeHeader(SAMFileHeader header, OutputStream out, String headerFile, CRAMReferenceSource referenceSource) {
        CRAMContainerStreamWriter cramWriter = new CRAMContainerStreamWriter(out, null, referenceSource, header, headerFile);
        cramWriter.writeHeader(header);
        cramWriter.finish(false);
    }
}

