/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.sam;

import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMLineParser;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.Locatable;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.HtsjdkReadsTraversalParameters;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.formats.sam.AbstractSamSource;
import org.disq_bio.disq.impl.formats.sam.SamFormat;
import org.disq_bio.disq.impl.formats.sam.TraversalOverlapDetector;

public class SamSource
extends AbstractSamSource
implements Serializable {
    public SamSource() {
        super(new HadoopFileSystemWrapper());
    }

    @Override
    public SamFormat getSamFormat() {
        return SamFormat.SAM;
    }

    @Override
    public <T extends Locatable> JavaRDD<SAMRecord> getReads(JavaSparkContext jsc, String path, int splitSize, HtsjdkReadsTraversalParameters<T> traversalParameters, ValidationStringency validationStringency, String referenceSourcePath) throws IOException {
        Configuration conf = jsc.hadoopConfiguration();
        if (splitSize > 0) {
            conf.setInt("mapreduce.input.fileinputformat.split.maxsize", splitSize);
        }
        SAMFileHeader samHeader = this.getFileHeader(jsc, path, validationStringency, referenceSourcePath);
        Broadcast samHeaderBroadcast = jsc.broadcast((Object)samHeader);
        Broadcast traversalParametersBroadcast = traversalParameters == null ? null : jsc.broadcast(traversalParameters);
        return this.textFile(jsc, path).mapPartitions((FlatMapFunction & Serializable)lines -> {
            SAMLineParser samLineParser = new SAMLineParser((SAMRecordFactory)new DefaultSAMRecordFactory(), validationStringency, (SAMFileHeader)samHeaderBroadcast.getValue(), null, null);
            TraversalOverlapDetector overlapDetector = traversalParametersBroadcast == null ? null : new TraversalOverlapDetector((HtsjdkReadsTraversalParameters)traversalParametersBroadcast.getValue());
            return SamSource.stream(lines).filter(line -> !line.startsWith("@")).map(arg_0 -> ((SAMLineParser)samLineParser).parseLine(arg_0)).filter(record -> overlapDetector == null || overlapDetector.overlapsAny((Locatable)record)).iterator();
        });
    }

    private <T extends Locatable> JavaRDD<String> textFile(JavaSparkContext jsc, String path) {
        return jsc.newAPIHadoopFile(path, TextInputFormat.class, LongWritable.class, Text.class, jsc.hadoopConfiguration()).map((Function & Serializable)pair -> ((Text)pair._2).toString()).setName(path);
    }
}

