/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.impl.file.HiddenFileFilter;

public interface FileSystemWrapper
extends Serializable {
    public boolean usesNio();

    public String normalize(Configuration var1, String var2) throws IOException;

    public SeekableStream open(Configuration var1, String var2) throws IOException;

    public OutputStream create(Configuration var1, String var2) throws IOException;

    public boolean delete(Configuration var1, String var2) throws IOException;

    public boolean exists(Configuration var1, String var2) throws IOException;

    public long getFileLength(Configuration var1, String var2) throws IOException;

    public boolean isDirectory(Configuration var1, String var2) throws IOException;

    public List<String> listDirectory(Configuration var1, String var2) throws IOException;

    public List<FileStatus> listDirectoryStatus(Configuration var1, String var2) throws IOException;

    public void concat(Configuration var1, List<String> var2, String var3) throws IOException;

    default public String firstFileInDirectory(Configuration conf, String path) throws IOException {
        Optional<String> firstPath = this.listDirectory(conf, path).stream().filter(new HiddenFileFilter()).findFirst();
        if (!firstPath.isPresent()) {
            throw new IllegalArgumentException("No files found in " + path);
        }
        return firstPath.get();
    }

    public static class FileStatus
    implements Comparable<FileStatus> {
        private static final Comparator<FileStatus> COMPARATOR = Comparator.comparing(FileStatus::getPath, Comparator.nullsFirst(String::compareTo)).thenComparingLong(FileStatus::getLength);
        private final String path;
        private final long length;

        public FileStatus(String path, long length) {
            this.path = path;
            this.length = length;
        }

        public String getPath() {
            return this.path;
        }

        public long getLength() {
            return this.length;
        }

        @Override
        public int compareTo(FileStatus o) {
            return COMPARATOR.compare(this, o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileStatus that = (FileStatus)o;
            return this.length == that.length && this.path.equals(that.path);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.length);
        }
    }
}

