/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats;

import htsjdk.samtools.util.RuntimeIOException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Consumer;

public class AutocloseIteratorWrapper<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private final Closeable closeable;

    public AutocloseIteratorWrapper(Iterator<E> iterator, Closeable closeable) {
        this.iterator = iterator;
        this.closeable = closeable;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            try {
                this.closeable.close();
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
        return hasNext;
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        this.iterator.forEachRemaining(action);
    }
}

