/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats;

import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import java.util.List;

public class BoundedTraversalUtil {
    public static <T extends Locatable> QueryInterval[] prepareQueryIntervals(List<T> rawIntervals, SAMSequenceDictionary sequenceDictionary) {
        if (rawIntervals == null || rawIntervals.isEmpty()) {
            return null;
        }
        QueryInterval[] convertedIntervals = (QueryInterval[])rawIntervals.stream().map(rawInterval -> BoundedTraversalUtil.convertSimpleIntervalToQueryInterval(rawInterval, sequenceDictionary)).toArray(QueryInterval[]::new);
        return QueryInterval.optimizeIntervals((QueryInterval[])convertedIntervals);
    }

    private static <T extends Locatable> QueryInterval convertSimpleIntervalToQueryInterval(T interval, SAMSequenceDictionary sequenceDictionary) {
        if (interval == null) {
            throw new IllegalArgumentException("interval may not be null");
        }
        if (sequenceDictionary == null) {
            throw new IllegalArgumentException("sequence dictionary may not be null");
        }
        int contigIndex = sequenceDictionary.getSequenceIndex(interval.getContig());
        if (contigIndex == -1) {
            throw new IllegalArgumentException("Contig " + interval.getContig() + " not present in reads sequence dictionary");
        }
        return new QueryInterval(contigIndex, interval.getStart(), interval.getEnd());
    }
}

