/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bam;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SBIIndexWriter;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.disq_bio.disq.BaiWriteOption;
import org.disq_bio.disq.SbiWriteOption;
import org.disq_bio.disq.impl.formats.bgzf.TerminatorlessBlockCompressedOutputStream;

public class HeaderlessBamOutputFormat
extends FileOutputFormat<Void, SAMRecord> {
    private static SAMFileHeader header;
    private static boolean writeSbiFile;
    private static boolean writeBaiFile;
    private static long sbiIndexGranularity;

    public static void setHeader(SAMFileHeader samFileHeader) {
        header = samFileHeader;
    }

    public static void setWriteSbiFile(boolean writeSbiFile) {
        HeaderlessBamOutputFormat.writeSbiFile = writeSbiFile;
    }

    public static void setWriteBaiFile(boolean writeBaiFile) {
        HeaderlessBamOutputFormat.writeBaiFile = writeBaiFile;
    }

    public static void setSbiIndexGranularity(long sbiIndexGranularity) {
        HeaderlessBamOutputFormat.sbiIndexGranularity = sbiIndexGranularity;
    }

    public RecordWriter<Void, SAMRecord> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Path file = this.getDefaultWorkFile(taskAttemptContext, "");
        Path sbiFile = writeSbiFile ? new Path(file.getParent(), "." + file.getName() + SbiWriteOption.getIndexExtension()) : null;
        Path baiFile = writeBaiFile ? new Path(file.getParent(), "." + file.getName() + BaiWriteOption.getIndexExtension()) : null;
        return new BamRecordWriter(taskAttemptContext.getConfiguration(), file, header, sbiFile, baiFile, sbiIndexGranularity);
    }

    static class BamRecordWriter
    extends RecordWriter<Void, SAMRecord> {
        private final Configuration conf;
        private final Path file;
        private final OutputStream out;
        private final BlockCompressedOutputStream compressedOut;
        private final BinaryCodec binaryCodec;
        private final BAMRecordCodec bamRecordCodec;
        private final SBIIndexWriter sbiIndexWriter;
        private final BAMIndexer bamIndexer;
        private SAMRecord previousSamRecord;
        private Chunk previousSamRecordChunk;

        public BamRecordWriter(Configuration conf, Path file, SAMFileHeader header, Path sbiFile, Path baiFile, long sbiIndexGranularity) throws IOException {
            this.conf = conf;
            this.file = file;
            this.out = file.getFileSystem(conf).create(file);
            this.compressedOut = new TerminatorlessBlockCompressedOutputStream(this.out);
            this.binaryCodec = new BinaryCodec((OutputStream)this.compressedOut);
            this.bamRecordCodec = new BAMRecordCodec(header);
            this.bamRecordCodec.setOutputStream((OutputStream)this.compressedOut);
            this.sbiIndexWriter = sbiFile != null ? new SBIIndexWriter((OutputStream)sbiFile.getFileSystem(conf).create(sbiFile), sbiIndexGranularity) : null;
            this.bamIndexer = baiFile != null ? new BAMIndexer((OutputStream)baiFile.getFileSystem(conf).create(baiFile), header, false) : null;
        }

        public void write(Void ignore, SAMRecord samRecord) {
            if (this.bamIndexer != null && this.previousSamRecord != null) {
                this.previousSamRecord.setFileSource(new SAMFileSource(null, (SAMFileSpan)new BAMFileSpan(this.previousSamRecordChunk)));
                this.bamIndexer.processAlignment(this.previousSamRecord);
            }
            long startOffset = this.compressedOut.getFilePointer();
            if (this.sbiIndexWriter != null) {
                this.sbiIndexWriter.processRecord(this.compressedOut.getFilePointer());
            }
            this.bamRecordCodec.encode(samRecord);
            long stopOffset = this.compressedOut.getFilePointer();
            this.previousSamRecord = samRecord;
            this.previousSamRecordChunk = new Chunk(startOffset, stopOffset);
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException {
            this.binaryCodec.close();
            long finalVirtualOffset = this.compressedOut.getFilePointer();
            long dataFileLength = this.file.getFileSystem(this.conf).getFileStatus(this.file).getLen();
            if (this.sbiIndexWriter != null) {
                this.sbiIndexWriter.finish(finalVirtualOffset, dataFileLength);
            }
            if (this.bamIndexer != null) {
                if (this.previousSamRecord != null) {
                    this.previousSamRecordChunk = new Chunk(this.previousSamRecordChunk.getChunkStart(), finalVirtualOffset);
                    this.previousSamRecord.setFileSource(new SAMFileSource(null, (SAMFileSpan)new BAMFileSpan(this.previousSamRecordChunk)));
                    this.bamIndexer.processAlignment(this.previousSamRecord);
                }
                this.bamIndexer.finish();
            }
        }
    }
}

