/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bgzf;

import htsjdk.samtools.util.AbstractIterator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.PathSplit;
import org.disq_bio.disq.impl.file.PathSplitSource;
import org.disq_bio.disq.impl.formats.SerializableHadoopConfiguration;
import org.disq_bio.disq.impl.formats.bgzf.BgzfBlockGuesser;

public class BgzfBlockSource
implements Serializable {
    private final PathSplitSource pathSplitSource;
    private final FileSystemWrapper fileSystemWrapper;

    public BgzfBlockSource(FileSystemWrapper fileSystemWrapper) {
        this.pathSplitSource = new PathSplitSource(fileSystemWrapper);
        this.fileSystemWrapper = fileSystemWrapper;
    }

    public JavaRDD<BgzfBlockGuesser.BgzfBlock> getBgzfBlocks(JavaSparkContext jsc, String path, int splitSize) throws IOException {
        Configuration conf = jsc.hadoopConfiguration();
        SerializableHadoopConfiguration confSer = new SerializableHadoopConfiguration(conf);
        return this.pathSplitSource.getPathSplits(jsc, path, splitSize).flatMap((FlatMapFunction & Serializable)pathSplit -> {
            BgzfBlockGuesser bgzfBlockGuesser = this.getBgzfSplitGuesser(confSer.getConf(), pathSplit.getPath());
            return BgzfBlockSource.getBgzfBlockIterator(bgzfBlockGuesser, pathSplit);
        });
    }

    private BgzfBlockGuesser getBgzfSplitGuesser(Configuration conf, String path) throws IOException {
        return new BgzfBlockGuesser(this.fileSystemWrapper.open(conf, path), path);
    }

    private static Iterator<BgzfBlockGuesser.BgzfBlock> getBgzfBlockIterator(BgzfBlockGuesser bgzfBlockGuesser, PathSplit split) {
        return BgzfBlockSource.getBgzfBlockIterator(bgzfBlockGuesser, split.getStart(), split.getEnd());
    }

    private static Iterator<BgzfBlockGuesser.BgzfBlock> getBgzfBlockIterator(final BgzfBlockGuesser bgzfBlockGuesser, final long splitStart, final long splitEnd) {
        return new AbstractIterator<BgzfBlockGuesser.BgzfBlock>(){
            long start;
            {
                this.start = splitStart;
            }

            protected BgzfBlockGuesser.BgzfBlock advance() {
                if (this.start >= splitEnd) {
                    bgzfBlockGuesser.close();
                    return null;
                }
                BgzfBlockGuesser.BgzfBlock bgzfBlock = bgzfBlockGuesser.guessNextBGZFPos(this.start, splitEnd);
                if (bgzfBlock == null) {
                    bgzfBlockGuesser.close();
                    return null;
                }
                this.start = bgzfBlock.pos + (long)bgzfBlock.cSize;
                return bgzfBlock;
            }
        };
    }
}

