/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.cram;

import htsjdk.samtools.CRAMCRAIIndexer;
import htsjdk.samtools.CRAMFileReader;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.cram.build.CramContainerHeaderIterator;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.PathChunk;
import org.disq_bio.disq.impl.file.PathSplitSource;
import org.disq_bio.disq.impl.formats.SerializableHadoopConfiguration;
import org.disq_bio.disq.impl.formats.sam.AbstractBinarySamSource;
import org.disq_bio.disq.impl.formats.sam.SamFormat;

public class CramSource
extends AbstractBinarySamSource
implements Serializable {
    private final PathSplitSource pathSplitSource;

    public CramSource(FileSystemWrapper fileSystemWrapper) {
        super(fileSystemWrapper);
        this.pathSplitSource = new PathSplitSource(fileSystemWrapper);
    }

    @Override
    public SamFormat getSamFormat() {
        return SamFormat.CRAM;
    }

    @Override
    protected JavaRDD<PathChunk> getPathChunks(JavaSparkContext jsc, String path, int splitSize, ValidationStringency stringency, String referenceSourcePath) throws IOException {
        Configuration conf = jsc.hadoopConfiguration();
        LinkedHashMap<String, NavigableSet<Long>> pathToContainerOffsets = new LinkedHashMap<String, NavigableSet<Long>>();
        if (this.fileSystemWrapper.isDirectory(conf, path)) {
            List statuses = this.fileSystemWrapper.listDirectoryStatus(conf, path).stream().filter(fs -> SamFormat.CRAM.fileMatches(fs.getPath())).collect(Collectors.toList());
            for (FileSystemWrapper.FileStatus status : statuses) {
                String p = status.getPath();
                long cramFileLength = status.getLength();
                NavigableSet<Long> containerOffsets = this.getContainerOffsetsFromIndex(conf, p, cramFileLength);
                String normPath = URI.create(this.fileSystemWrapper.normalize(conf, p)).getPath();
                pathToContainerOffsets.put(normPath, containerOffsets);
            }
        } else {
            long cramFileLength = this.fileSystemWrapper.getFileLength(conf, path);
            NavigableSet<Long> containerOffsets = this.getContainerOffsetsFromIndex(conf, path, cramFileLength);
            String normPath = URI.create(this.fileSystemWrapper.normalize(conf, path)).getPath();
            pathToContainerOffsets.put(normPath, containerOffsets);
        }
        Broadcast containerOffsetsBroadcast = jsc.broadcast(pathToContainerOffsets);
        SerializableHadoopConfiguration confSer = new SerializableHadoopConfiguration(jsc.hadoopConfiguration());
        return this.pathSplitSource.getPathSplits(jsc, path, splitSize).flatMap((FlatMapFunction & Serializable)pathSplit -> {
            long newEnd;
            String normPath;
            Configuration c = confSer.getConf();
            String p = pathSplit.getPath();
            Map pathToOffsets = (Map)containerOffsetsBroadcast.getValue();
            NavigableSet offsets = (NavigableSet)pathToOffsets.get(normPath = URI.create(this.fileSystemWrapper.normalize(c, p)).getPath());
            long newStart = offsets.ceiling(pathSplit.getStart());
            if (newStart == (newEnd = offsets.ceiling(pathSplit.getEnd()).longValue())) {
                return Collections.emptyIterator();
            }
            PathChunk pathChunk = new PathChunk(p, new Chunk(BlockCompressedFilePointerUtil.makeFilePointer((long)newStart), BlockCompressedFilePointerUtil.makeFilePointer((long)(newEnd - 1L))));
            return Collections.singleton(pathChunk).iterator();
        });
    }

    private NavigableSet<Long> getContainerOffsetsFromIndex(Configuration conf, String path, long cramFileLength) throws IOException {
        try (SeekableStream in = this.findIndex(conf, path);){
            if (in == null) {
                NavigableSet<Long> navigableSet = this.getContainerOffsetsFromFile(conf, path, cramFileLength);
                return navigableSet;
            }
            TreeSet<Long> containerOffsets = new TreeSet<Long>();
            CRAIIndex index = CRAMCRAIIndexer.readIndex((InputStream)in);
            for (CRAIEntry entry : index.getCRAIEntries()) {
                containerOffsets.add(entry.getContainerStartByteOffset());
            }
            containerOffsets.add(cramFileLength);
            TreeSet<Long> treeSet = containerOffsets;
            return treeSet;
        }
    }

    private NavigableSet<Long> getContainerOffsetsFromFile(Configuration conf, String path, long cramFileLength) throws IOException {
        try (SeekableStream seekableStream = this.fileSystemWrapper.open(conf, path);){
            CramContainerHeaderIterator it = new CramContainerHeaderIterator((InputStream)seekableStream);
            TreeSet<Long> containerOffsets = new TreeSet<Long>();
            while (it.hasNext()) {
                Container container = it.next();
                containerOffsets.add(container.byteOffset);
            }
            containerOffsets.add(cramFileLength);
            TreeSet<Long> treeSet = containerOffsets;
            return treeSet;
        }
    }

    private CRAMFileReader getUnderlyingCramFileReader(SamReader samReader) {
        return (CRAMFileReader)((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader).underlyingReader();
    }

    @Override
    protected CloseableIterator<SAMRecord> getIterator(SamReader samReader, SAMFileSpan chunks) {
        return this.getUnderlyingCramFileReader(samReader).getIterator(chunks);
    }

    @Override
    protected CloseableIterator<SAMRecord> createIndexIterator(SamReader samReader, QueryInterval[] intervals, boolean contained, long[] filePointers) {
        return this.getUnderlyingCramFileReader(samReader).createIndexIterator(intervals, contained, filePointers);
    }

    @Override
    protected int getMinUnplacedUnmappedReadsCoordinateCount() {
        return 0;
    }
}

