/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.sam;

import com.google.common.collect.Iterators;
import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Locatable;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.HtsjdkReadsTraversalParameters;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.PathChunk;
import org.disq_bio.disq.impl.formats.AutocloseIteratorWrapper;
import org.disq_bio.disq.impl.formats.BoundedTraversalUtil;
import org.disq_bio.disq.impl.formats.SerializableHadoopConfiguration;
import org.disq_bio.disq.impl.formats.sam.AbstractSamSource;

public abstract class AbstractBinarySamSource
extends AbstractSamSource {
    protected AbstractBinarySamSource(FileSystemWrapper fileSystemWrapper) {
        super(fileSystemWrapper);
    }

    @Override
    public <T extends Locatable> JavaRDD<SAMRecord> getReads(JavaSparkContext jsc, String path, int splitSize, HtsjdkReadsTraversalParameters<T> traversalParameters, ValidationStringency validationStringency, String referenceSourcePath) throws IOException {
        if (traversalParameters != null && traversalParameters.getIntervalsForTraversal() == null && !traversalParameters.getTraverseUnplacedUnmapped()) {
            throw new IllegalArgumentException("Traversing mapped reads only is not supported.");
        }
        Broadcast traversalParametersBroadcast = traversalParameters == null ? null : jsc.broadcast(traversalParameters);
        SerializableHadoopConfiguration confSer = new SerializableHadoopConfiguration(jsc.hadoopConfiguration());
        return this.getPathChunks(jsc, path, splitSize, validationStringency, referenceSourcePath).mapPartitions((FlatMapFunction & Serializable)pathChunks -> {
            Iterator intervalReadsIterator;
            HtsjdkReadsTraversalParameters traversal;
            Configuration c = confSer.getConf();
            if (!pathChunks.hasNext()) {
                return Collections.emptyIterator();
            }
            PathChunk pathChunk = (PathChunk)pathChunks.next();
            if (pathChunks.hasNext()) {
                throw new IllegalArgumentException("Should not have more than one path chunk per partition");
            }
            String p = pathChunk.getPath();
            SamReader samReader = this.createSamReader(c, p, validationStringency, referenceSourcePath);
            BAMFileSpan splitSpan = new BAMFileSpan(pathChunk.getSpan());
            HtsjdkReadsTraversalParameters htsjdkReadsTraversalParameters = traversal = traversalParametersBroadcast == null ? null : (HtsjdkReadsTraversalParameters)traversalParametersBroadcast.getValue();
            if (traversal == null) {
                return new AutocloseIteratorWrapper<SAMRecord>((Iterator<SAMRecord>)this.getIterator(samReader, (SAMFileSpan)splitSpan), (Closeable)samReader);
            }
            if (!samReader.hasIndex()) {
                samReader.close();
                throw new IllegalArgumentException("Intervals set but no index file found for " + p);
            }
            BAMIndex idx = samReader.indexing().getIndex();
            long startOfLastLinearBin = idx.getStartOfLastLinearBin();
            long noCoordinateCount = ((AbstractBAMFileIndex)idx).getNoCoordinateCount();
            if (traversal.getIntervalsForTraversal() == null || traversal.getIntervalsForTraversal().isEmpty()) {
                intervalReadsIterator = Collections.emptyIterator();
                samReader.close();
            } else {
                SAMFileHeader header = samReader.getFileHeader();
                QueryInterval[] queryIntervals = BoundedTraversalUtil.prepareQueryIntervals(traversal.getIntervalsForTraversal(), header.getSequenceDictionary());
                BAMFileSpan span = BAMFileReader.getFileSpan((QueryInterval[])queryIntervals, (BAMIndex)idx);
                span = (BAMFileSpan)span.removeContentsBefore((SAMFileSpan)splitSpan);
                span = (BAMFileSpan)span.removeContentsAfter((SAMFileSpan)splitSpan);
                intervalReadsIterator = new AutocloseIteratorWrapper<SAMRecord>((Iterator<SAMRecord>)this.createIndexIterator(samReader, queryIntervals, false, span.toCoordinateArray()), (Closeable)samReader);
            }
            if (traversal.getTraverseUnplacedUnmapped() && startOfLastLinearBin != -1L && noCoordinateCount >= (long)this.getMinUnplacedUnmappedReadsCoordinateCount()) {
                long unplacedUnmappedStart = startOfLastLinearBin;
                if (pathChunk.getSpan().getChunkStart() <= unplacedUnmappedStart && unplacedUnmappedStart < pathChunk.getSpan().getChunkEnd()) {
                    SamReader unplacedUnmappedReadsSamReader = this.createSamReader(c, p, validationStringency, referenceSourcePath);
                    AutocloseIteratorWrapper unplacedUnmappedReadsIterator = new AutocloseIteratorWrapper(unplacedUnmappedReadsSamReader.queryUnmapped(), (Closeable)unplacedUnmappedReadsSamReader);
                    return Iterators.concat(intervalReadsIterator, unplacedUnmappedReadsIterator);
                }
            }
            return intervalReadsIterator;
        });
    }

    protected abstract JavaRDD<PathChunk> getPathChunks(JavaSparkContext var1, String var2, int var3, ValidationStringency var4, String var5) throws IOException;

    protected abstract CloseableIterator<SAMRecord> getIterator(SamReader var1, SAMFileSpan var2);

    protected abstract CloseableIterator<SAMRecord> createIndexIterator(SamReader var1, QueryInterval[] var2, boolean var3, long[] var4);

    protected int getMinUnplacedUnmappedReadsCoordinateCount() {
        return 1;
    }
}

